"use strict";
var form = document.querySelector('#sports_form');
var submitButton = document.querySelector('#kt_modal_new_target_submit');
var modal = $('#kt_modal_new_target');
var validator;
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});
var sports_sports = {
    init: function() {
        ! function() {
            const t = $("#sports_table");
            $("#sports_table").DataTable({
                url: "{{route('admin.categories.index')}}",
                type: "POST",
                processing: true,
                serverSide: true,
                stateSave: true,
                bDestroy: true,
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'category.name',
                        name: 'sports'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'image',
                        name: 'image'
                    },
                    {
                        data: 'slug',
                        name: 'slug'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                columnDefs: [{
                    targets: 3,
                    render: function(data) {
                        if (data) {

                            return '<img src="' + data + '">'
                        }


                    }
                }]

            })
        }()
    }


};

var handleForm = function() {

    // Stepper custom navigation
    $('.invalid-feedback').remove();
    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
    validator = FormValidation.formValidation(
        form, {
            fields: {

                sports_name: {
                    validators: {
                        notEmpty: {
                            message: 'Sports Name is Required'
                        }
                    }
                },
                category_type: {
                    validators: {
                        notEmpty: {
                            message: 'Category Type is Required'
                        }
                    }
                },
                sports_type: {
                    validators: {
                        notEmpty: {
                            message: 'Sports Type is Required'
                        }
                    }
                },
                sports_price: {
                    validators: {
                        notEmpty: {
                            message: 'Price is Required'
                        }
                    }
                },
                sports_mem_price: {
                    validators: {
                        notEmpty: {
                            message: 'Membership Price is Required'
                        }
                    }
                },
              'targets_notifications[]': {
                    validators: {
                        notEmpty: {
                            message: 'Please select at least one communication method'
                        }
                    }
                },
            },
            plugins: {

                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.fv-row',
                    eleInvalidClass: '',
                    eleValidClass: ''
                })
            }
        }

    );


}

$(document).on("click", ".edit_sports", function() {
    let data_id = $(this).attr('data-id');
    let c_edit = spo_edit.replace(':id', data_id);

    axios.get(c_edit, {
            '_method': 'GET',
            'dataType': 'JSON'
         })
        .then(function(response) {
            response = (response.data);
            $('#kt_modal_new_target').modal('toggle');
            $('.add-label').html('Edit sports');
            $('#sports_name').val(response.data.name);
            $('select[name="category_type"] option[value="'+response.data.category+'"]').attr('selected', 'selected').trigger('change');
            $('select[name="sports_type"] option[value="'+response.data.type+'"]').attr('selected', 'selected').trigger('change');
            $('.sport_img').attr('style', "background-image: url('"+ response.data.image + "')");
            $('.sport_bg_img').attr('style', "background-image: url('"+ response.data.background_image + "')");
            $('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="sports_id" value="' + data_id + '" id="edit_sports_id">');
            $('#sports_price').val(response.data.price);
            $('#sports_mem_price').val(response.data.member_price);
        }).catch(function(error) {

        });
});
$('#kt_modal_new_target').on('hidden.bs.modal', function() {
    $('.add-label').html('Add sports');
    form.reset();
    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
    $('#append_div').empty();
})
$(document).on("click", ".delete_sports", function(e) {

    var data_id = $(this).attr('data-id');
    var spo_delete1 = spo_delete.replace(':id', data_id);
    e.preventDefault();

    Swal.fire({
        title: 'Are you sure to delete this record?',
        showDenyButton: true,

        confirmButtonText: 'Yes',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            axios.delete(spo_delete1, {
                    '_method': 'DELETE',
                    'dataType': 'JSON'

                })
                .then(function(response) {
                    {
                        response = (response.data)
                        if (response.success) {

                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#sports_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        } else {
                            Swal.fire({
                                text: response.message,
                                icon: "danger",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#sports_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }
                    };
                })
                .catch(function(error) {
                    console.log(error);
                });
        } else if (result.isDenied) {
            //Swal.fire('Changes are not saved', '', 'info')
        }
    })




});
$(document).on("click", "#add_sports", function() {
    $('#kt_modal_new_target').modal('show');
});

$(document).on('submit', "#sports_form", function() {
    var cid = ($('#edit_sports_id').val());
    var method;
    var action;
    if (!cid) {
        action = spo_store;
    } else {
        action = spo_update;
        action = action.replace(':id', cid);
    }
    $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
    handleForm();
    if (validator) {
        // Validate form
        validator.validate().then(function(status) {
            $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
            if (status === 'Valid') {
                // Send ajax request
                axios.post(action, new FormData(form))
                    .then(function(response) {
                        response = response.data;
                        if (response.success) {
                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    form.reset(); // Reset form	
                                    $('#kt_modal_new_target').modal('toggle');
                                    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
                                    $("#sports_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }


                    })
                    .catch(function(error) {
                        console.log(error)
                        let dataMessage = error.response.data.message;
                        let dataErrors = error.response.data.errors;

                        for (const errorsKey in dataMessage) {
                            if (!dataErrors.hasOwnProperty(errorsKey))
                                continue;
                            dataMessage += "\r\n" + dataErrors[errorsKey];

                        }

                        if (error.response) {
                            Swal.fire({
                                text: dataMessage,
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                        }
                    })
                    .then(function() {
                        // always executed
                        // Hide loading indication
                        submitButton.removeAttribute('data-kt-indicator');

                        // Enable button
                        submitButton.disabled = false;

                    });

            } else {

            }

        });

    }
    return false;
});

$(function() {
    sports_sports.init();



});


$(document).on("click", ".view_courts", function() {
    var cid=($(this).attr('data-id'));
    var url=spo_view_courts.replace(':id', cid);
    location.href=url;
    
});