"use strict";
var form = document.querySelector('#role_form');
var submitButton = document.querySelector('#kt_modal_new_target_submit');
var modal=$('#kt_modal_new_target');
var validator;
$.ajaxSetup({
	headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	}
});
var sports_roles = {
    init: function() {
        ! function() {
            const t = $("#roles_table");
			var table = $("#roles_table").DataTable({
                type: "POST",
                processing: true,
                serverSide: true,
			    stateSave: true ,
				bDestroy:true,
				columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                    {data: 'name', name: 'name'},
                 
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]

            });
			$('table').on('draw.dt', function() {
				$('[data-bs-toggle="tooltip"]').tooltip();
			})

				
        }()
    }

    
};

var handleForm = function() {

	// Stepper custom navigation
   $('.invalid-feedback').remove();
	// Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
	validator = FormValidation.formValidation(
		form,
		{
			fields: {
				
				role_name: {
					validators: {
						notEmpty: {
							message: 'roles Name is Required'
						}
					}
				},
				'permission[]': {
					validators: {
						notEmpty: {
							message: 'Atleast select one permission'
						}
					}
				}
                ,
				
				'targets_notifications[]': {
					validators: {
						notEmpty: {
							message: 'Please select at least one communication method'
						}
					}
				},
			},
			plugins: {
				trigger: new FormValidation.plugins.Trigger(),
				bootstrap: new FormValidation.plugins.Bootstrap5({
					rowSelector: '.fv-row',
					eleInvalidClass: '',
					eleValidClass: ''
				})
			}
		}
		
	);


}
var handleFormEdit = function() {

	// Stepper custom navigation
   $('.invalid-feedback').remove();
	// Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
	validator = FormValidation.formValidation(
		form,
		{
			fields: {
				
				role_name: {
					validators: {
						notEmpty: {
							message: 'Users Name is Required'
						}
					}
				},
				
				'targets_notifications[]': {
					validators: {
						notEmpty: {
							message: 'Please select at least one communication method'
						}
					}
				},
			},
			plugins: {
				trigger: new FormValidation.plugins.Trigger(),
				bootstrap: new FormValidation.plugins.Bootstrap5({
					rowSelector: '.fv-row',
					eleInvalidClass: '',
					eleValidClass: ''
				})
			}
		}
		
	);


}
$(document).on("click",".edit_role",function() {
    let data_id=$(this).attr('data-id');
	let role_edit1=role_edit.replace(':id',data_id);
	axios.get(role_edit1, {
		'_method': 'GET',
		'dataType':'JSON'

	})
	.then(function(response) {
		response=(response.data);
		$('#kt_modal_new_target').modal('toggle');
		$('.add-label').html('Edit roles');
		$('#role_name').val(response.data.role.name);
		$.each(response.data.rolePermissions, function(i, val){
			$("input[name='permission[]'][value='" + val + "']").prop('checked', true);
		});
		$('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="role_id" value="'+data_id+'" id="edit_roles_id">');
		
	}).catch(function(error){

	});
});
$('#kt_modal_new_target').on('hidden.bs.modal', function () {
	  $('.add-label').html('Add Roles');
	  form.reset();
	  $('.image-input-wrapper').attr('style',"background-image: url('"+hostUrl+"admin/assets/media/avatars/upload.png')");
	  $('#append_div').empty();					
  })
$(document).on("click",".delete_role",function(e) {
	
	var data_id=$(this).attr('data-id');
	var role_delete1=role_delete.replace(':id',data_id);
	e.preventDefault();
	
	Swal.fire({
		title: 'Are you sure to delete this record?',
		showDenyButton: true,
	
		confirmButtonText: 'Yes',
		
	  }).then((result) => {
		/* Read more about isConfirmed, isDenied below */
		if (result.isConfirmed) {
			axios.delete(role_delete1, {
				'_method': 'DELETE',
				'dataType':'JSON'
		
			})
			.then(function(response) {
				{
					response=(response.data)
					if(response.success){
					
						Swal.fire({
							text: response.message,
							icon: "success",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						}).then(function (result) {
							if (result.isConfirmed) {
								$("#roles_table").DataTable().ajax.reload(null, false);
							}
						});
					}else{
						Swal.fire({
							text: response.message,
							icon: "danger",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-danger"
							}
						}).then(function (result) {
							if (result.isConfirmed) {
								$("#roles_table").DataTable().ajax.reload(null, false);
							}
						});
					}
				};
			})
			.catch(function(error) {
				console.log(error);
			});
		} else if (result.isDenied) {
		  //Swal.fire('Changes are not saved', '', 'info')
		}
	  })
   

  




});
$(document).on("click","#add_role",function() {
    $('#kt_modal_new_target').modal('show');
});

$(document).on('submit',"#role_form",function(){
  
	var cid=($('#edit_roles_id').val());
	var method;
	var action;
	$('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
	if(!cid){
		action=role_store;
	    handleForm();

	}else{
		action=role_update;
		action=action.replace(':id',cid);
	   	handleFormEdit();
	}

   	if (validator) {
		// Validate form
		validator.validate().then(function (status) {
			$('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
			if (status === 'Valid') {
				// Send ajax request
				axios.post(action,new FormData(form))
				.then(function (response) {
					response=response.data;
					if(response.success){
						Swal.fire({
							text: response.message,
							icon: "success",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						}).then(function (result) {
							if (result.isConfirmed) {
								form.reset(); // Reset form	
								$('#kt_modal_new_target').modal('toggle');
								$('.image-input-wrapper').attr('style',"background-image: url('"+hostUrl+"admin/assets/media/avatars/upload.png')");
								$("#roles_table").DataTable( ).ajax.reload(null, false);
							}
						});
					}
					
					
				})
				.catch(function (error) {
					console.log(error)
					let dataMessage = error.response.data.message;
					let dataErrors = error.response.data.errors;
					
					for (const errorsKey in dataMessage) {
						if (!dataErrors.hasOwnProperty(errorsKey)) 
						continue;
						dataMessage += "\r\n" + dataErrors[errorsKey];
						
					}

					if (error.response) {
						Swal.fire({
							text: dataMessage,
							icon: "error",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						});
					}
				})
				.then(function () {
					// always executed
					// Hide loading indication
					submitButton.removeAttribute('data-kt-indicator');

					// Enable button
					submitButton.disabled = false;
					
				});
             
			}else{
				
			}
          
		});

	}
    return false;
});

$(function() {
	sports_roles.init();
});