"use strict";
var form = document.querySelector('#kt_account_profile_details_form');
var submitButton = document.querySelector('#kt_account_setting_submit');
var modal = $('#kt_modal_new_target');
var validator;
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});
var players = {

};

var handleForm = function() {

    // Stepper custom navigation
    $('.invalid-feedback').remove();
    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
    validator = FormValidation.formValidation(
        form, {
            fields: {

                playcoin_cashback_nuser: {
                    validators: {
                        notEmpty: {
                            message: 'Enter Playcoin Cachback - Normal user'
                        }
                    }
                },
                playcoin_cashback_muser: {
                    validators: {
                        notEmpty: {
                            message: 'Enter Playcoin Cachback - Membership user'
                        }
                    }
                },
                play_coin_max_use: {
                    validators: {
                        notEmpty: {
                            message: 'Enter Playcoin Max Use for booking'
                        }
                    }
                },
                referal_sender_gain: {
                    validators: {
                        notEmpty: {
                            message: 'Enter Referal Sender Get Coin'
                        }
                    }
                },
                referal_receiver_gain: {
                    validators: {
                        notEmpty: {
                            message: 'Enter Referal Receiver Get Coin'
                        }
                    }
                },
               
                referal_link: {
                    validators: {
                        notEmpty: {
                            message: 'Enter Referal links'
                        }
                    }
                },
               
                referal_percentage: {
                    validators: {
                        notEmpty: {
                            message: 'Enter Referal Percentage'
                        }
                    }
                },
                
                cancel_approve_max_hour: {
                    validators: {
                        notEmpty: {
                            message: 'Enter approve cancel of max hour'
                        }
                    }
                },
               
               
              'targets_notifications[]': {
                    validators: {
                        notEmpty: {
                            message: 'Please select at least one communication method'
                        }
                    }
                },
            },
            plugins: {

                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.fv-row',
                    eleInvalidClass: '',
                    eleValidClass: ''
                })
            }
        }

    );


}



$(document).on("click", ".delete_customer", function(e) {

    var data_id = $(this).attr('data-id');
    var ply_delete1 = ply_delete.replace(':id', data_id);
    e.preventDefault();

    Swal.fire({
        title: 'Are you sure to delete this record?',
        showDenyButton: true,

        confirmButtonText: 'Yes',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            axios.delete(ply_delete1, {
                    '_method': 'DELETE',
                    'dataType': 'JSON'

                })
                .then(function(response) {
                    {
                        response = (response.data)
                        if (response.success) {

                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#booking_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        } else {
                            Swal.fire({
                                text: response.message,
                                icon: "danger",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#booking_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }
                    };
                })
                .catch(function(error) {
                    console.log(error);
                });
        } else if (result.isDenied) {
            //Swal.fire('Changes are not saved', '', 'info')
        }
    })




});

$(document).on('submit',form, function() {
    
    var cid = ($('#edit_player_id').val());
    var method;
    var action;
    if (!cid) {
        action = setting_store;
    } else {
        action = setting_update;
        action = action.replace(':id', cid);
    }
    $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
    handleForm();
    if (validator) {
        // Validate form
        validator.validate().then(function(status) {
            $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
            if (status === 'Valid') {
                // Send ajax request
                axios.post(action, new FormData(form))
                    .then(function(response) {
                        response = response.data;
                        if (response.success) {
                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                               
                            });
                        }


                    })
                    .catch(function(error) {
                        console.log(error)
                        let dataMessage = error.response.data.message;
                        let dataErrors = error.response.data.errors;

                        for (const errorsKey in dataMessage) {
                            if (!dataErrors.hasOwnProperty(errorsKey))
                                continue;
                            dataMessage += "\r\n" + dataErrors[errorsKey];

                        }

                        if (error.response) {
                            Swal.fire({
                                text: dataMessage,
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                        }
                    })
                    .then(function() {
                        // always executed
                        // Hide loading indication
                        submitButton.removeAttribute('data-kt-indicator');

                        // Enable button
                        submitButton.disabled = false;

                    });

            } else {

            }

        });

    }
    return false;
});

$(function() {
  //  players.init();



});






