"use strict";
var form = document.querySelector('#membership_form');
var submitButton = document.querySelector('#kt_modal_new_target_submit');
var modal = $('#kt_modal_new_target');
var validator;
var table_name = $("#tournament_table");
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});
var sports_sports = {
    init: function() {
        ! function() {
           
            table_name.DataTable({

                url: "{{route('admin.categories.index')}}",
                type: "POST",
                processing: true,
                serverSide: true,
                stateSave: true,
                bDestroy: true,
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'date',
                        name: 'date'
                    },
                    {
                        data: 'time',
                        name: 'time'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]

            })
        }()
    }


};

var handleForm = function() {

    // Stepper custom navigation
    $('.invalid-feedback').remove();
    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
    validator = FormValidation.formValidation(
        form, {
            fields: {

                mem_duration: {
                    validators: {
                        notEmpty: {
                            message: 'Please Select Membership Duration'
                        }
                    }
                },
                mem_package: {
                    validators: {
                        notEmpty: {
                            message: 'Please select Membership Package'
                        }
                    }
                },
                mem_discount: {
                    validators: {
                        notEmpty: {
                            message: 'Plese enter  discount value'
                        }
                    }
                },
                mem_discount_type: {
                    validators: {
                        notEmpty: {
                            message: 'Please select discount type'
                        }
                    }
                },
            //    image_json: {
            //         validators: {
            //             notEmpty: {
            //                 message: 'Please choose image json'
            //             }
            //         }
            //     },
       
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.fv-row',
                    eleInvalidClass: '',
                    eleValidClass: ''
                })
            }
        }

    );


}

$(document).on("click", ".edit_tournament", function() {

    let data_id = $(this).attr('data-id');
    let c_edit = touranament_edit.replace(':id', data_id);

    axios.get(c_edit, {
            '_method': 'GET',
            'dataType': 'JSON'

        })
        .then(function(response) {
            response = (response.data);
            $('#kt_modal_new_target').modal('toggle');
            $('.add-label').html('Edit Tournament');
            $('#touranament_name').val(response.data.name);
            $('#touranament_date').val(response.data.date);
            $('#touranament_time').val(response.data.time);
            $('select[name="touranament_status"] option[value="'+response.data.status+'"]').attr('selected', 'selected').trigger('change');
            $('#summernote').summernote('reset');
            $('#summernote').empty().summernote('editor.pasteHTML', response.data.description);
            $('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="tournament_id" value="' + response.data.id + '" id="edit_plan_id">');
           //console.log(response.data.membership_description);
           $('.tournament_img1').attr('style', "background-image: url('"+ response.data.images[0]['image'] + "')");
           $('.tournament_img2').attr('style', "background-image: url('"+ response.data.images[1]['image'] + "')");
           $('.tournament_img3').attr('style', "background-image: url('"+ response.data.images[2]['image'] + "')");
           
        }).catch(function(error) {

        });
});
$('#kt_modal_new_target').on('hidden.bs.modal', function() {
    $('.add-label').html('Add plans');
    form.reset();
   // $('select[name="mem_duration"]').empty().trigger('change');
  //  $('select[name="mem_package]').empty().trigger('change');
    $('#append_div').empty();
})
$(document).on("click", ".delete_tournament", function(e) {
    var data_id = $(this).attr('data-id');
    var touranament_delete1 = touranament_delete.replace(':id', data_id);
    e.preventDefault();

    Swal.fire({
        title: 'Are you sure to delete this record?',
        showDenyButton: true,

        confirmButtonText: 'Yes',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            axios.delete(touranament_delete1, {
                    '_method': 'DELETE',
                    'dataType': 'JSON'

                })
                .then(function(response) {
                    {
                        response = (response.data)
                        if (response.success) {

                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    table_name.DataTable().ajax.reload(null, false);
                                }
                            });
                        } else {
                            Swal.fire({
                                text: response.message,
                                icon: "danger",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    table_name.DataTable().ajax.reload(null, false);
                                }
                            });
                        }
                    };
                })
                .catch(function(error) {
                    console.log(error);
                });
        } else if (result.isDenied) {
            //Swal.fire('Changes are not saved', '', 'info')
        }
    })




});
$(document).on("click", "#add_sports", function() {
    $('#kt_modal_new_target').modal('show');
});

$(document).on('submit', "#membership_form", function() {
    

    var cid = ($('#edit_plan_id').val());
    var method;
    var action;
    if (!cid) {
        action = touranament_store;
    } else {
        action = touranament_update;
        action = action.replace(':id', cid);
    }
   
    $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
    handleForm();

    if (validator) {
        // Validate form
        validator.validate().then(function(status) {
            $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
            if (status === 'Valid') {
                // Send ajax request
                axios.post(action, new FormData(form))
                    .then(function(response) {
                        response = response.data;
                        if (response.success) {
                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    form.reset(); // Reset form	
                                    $('#kt_modal_new_target').modal('toggle');
                                    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
                                    $("#tournament_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }


                    })
                    .catch(function(error) {
                        console.log(error)
                        let dataMessage = error.response.data.message;
                        let dataErrors = error.response.data.errors;

                        for (const errorsKey in dataMessage) {
                            if (!dataErrors.hasOwnProperty(errorsKey))
                                continue;
                            dataMessage += "\r\n" + dataErrors[errorsKey];

                        }

                        if (error.response) {
                            Swal.fire({
                                text: dataMessage,
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                        }
                    })
                    .then(function() {
                        // always executed
                        // Hide loading indication
                        submitButton.removeAttribute('data-kt-indicator');

                        // Enable button
                        submitButton.disabled = false;

                    });

            } else {

            }

        });

    }
    return false;
});


$(document).on('click', ".add_tournament_inc", function() {
     $('#membership_desc_table tr:last').after(' <tr> <td> <div class="reload"> <label class="form-label fw-semibold">Image Json</label> <div> <input type="file" class="form-control form-control-solid" name="image[]" id="image_json"/> </div></div></td><td> <button type="button" class="btn btn-icon btn-active-light-primary w-30px h-30px ms-auto delete_tournament_desc" data-id="" id=""> <span class="svg-icon svg-icon-3"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M5 9C5 8.44772 5.44772 8 6 8H18C18.5523 8 19 8.44772 19 9V18C19 19.6569 17.6569 21 16 21H8C6.34315 21 5 19.6569 5 18V9Z" fill="currentColor"></path> <path opacity="0.5" d="M5 5C5 4.44772 5.44772 4 6 4H18C18.5523 4 19 4.44772 19 5V5C19 5.55228 18.5523 6 18 6H6C5.44772 6 5 5.55228 5 5V5Z" fill="currentColor"></path> <path opacity="0.5" d="M9 4C9 3.44772 9.44772 3 10 3H14C14.5523 3 15 3.44772 15 4V4H9V4Z" fill="currentColor"></path></svg></span></button> </td></tr>');
});

$(document).on('click','.delete_tournament_desc',function(){
    console.log($(this).parents('tr').remove());
});

$(function() {
    sports_sports.init();
});

$(document).on('click','.add_tournament_img',function(){

    $(".image_append:last").before(' <div class="col image_append"> <div class="d-flex flex-column mb-8 fv-row"> <label class="form-label fw-semibold">Image</label> <div> <div class="image-input image-input-outline" data-kt-image-input="true" style="background-image: url()"> <div class="image-input-wrapper w-125px h-125px sport_img" style="background-image: url()"> </div><label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change avatar"> <i class="bi bi-pencil-fill fs-7"></i> <input type="file" name="file[]" accept=".png, .jpg, .jpeg"  /> <input type="hidden" name="avatar_remove"/> </label> <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel avatar"> <i class="bi bi-x fs-2"></i> </span> <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow remove_tour_img" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove avatar"> <i class="bi bi-x fs-2"></i> </span> </div><div class="form-text">Allowed file types: png, jpg, jpeg.</div></div></div></div>');

});

$(document).on('click','.remove_tour_img',function(){
   
    console.log($(this).parent('div').parent('div').parent('div').parent('div').remove());

});

// $(document).on('change','input[name="file[]"]',function(){
   
//     console.log($(this).parent('i').html());

// });

$(document).on('change','input[name="file[]"]',function(e){
    
    var file  = e.target.files[0];
             
     var reader = new FileReader();
    var attr= $(this).parent().parent('div').children('.image-input-wrapper');
        reader.onload = function (e) {
            attr
                .attr('style','background-image: url('+ e.target.result+')')
                .width(150)
                .height(200);
        };

        reader.readAsDataURL(e.target.files[0]);
  
    //console.log($(this).parent().parent('div').children('.image-input-wrapper').attr('style','background-image: url('+file+')'));

});




// function readURL(input) {
//     console.log(input.parent('div').html());
//     if (input.files && input.files[0]) {
//         alert();
//         var reader = new FileReader();

//         reader.onload = function (e) {
//             $('#ShowImage')
//                 .attr('src', e.target.result)
//                 .width(150)
//                 .height(200);
//         };

//         reader.readAsDataURL(input.files[0]);
//     }
// }