"use strict";
var form = document.querySelector('#user_form');
var submitButton = document.querySelector('#kt_modal_new_target_submit');
var modal=$('#kt_modal_new_target');
var validator;
$.ajaxSetup({
	headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	}
});
var sports_users = {
    init: function() {
        ! function() {
            const t = $("#users_table");
			var table = $("#users_table").DataTable({
                
                url: "{{route('admin.categories.index')}}",
                type: "POST",
                processing: true,
                serverSide: true,
			    stateSave: true ,
				bDestroy:true,
				columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'role', name: 'role'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]

            });
			$('table').on('draw.dt', function() {
				$('[data-bs-toggle="tooltip"]').tooltip();
			})

				
        }()
    }

    
};

var handleForm = function() {

	// Stepper custom navigation
   $('.invalid-feedback').remove();
	// Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
	validator = FormValidation.formValidation(
		form,
		{
			fields: {
				
				user_name: {
					validators: {
						notEmpty: {
							message: 'Users Name is Required'
						}
					}
				},
                user_email: {
					validators: {
						notEmpty: {
							message: 'Users Email is Required'
						}
					}
				},
                user_password: {
					validators: {
						notEmpty: {
							message: 'Users Password is Required'
						}
					}
				},
                user_confim_pass: {
					validators: {
						notEmpty: {
							message: 'Users Confirm Passowrd is Required'
						}
					}
				},
                user_role: {
					validators: {
						notEmpty: {
							message: 'Users Role is Required'
						}
					}
				},
				
				'targets_notifications[]': {
					validators: {
						notEmpty: {
							message: 'Please select at least one communication method'
						}
					}
				},
			},
			plugins: {
				trigger: new FormValidation.plugins.Trigger(),
				bootstrap: new FormValidation.plugins.Bootstrap5({
					rowSelector: '.fv-row',
					eleInvalidClass: '',
					eleValidClass: ''
				})
			}
		}
		
	);


}
var handleFormEdit = function() {

	// Stepper custom navigation
   $('.invalid-feedback').remove();
	// Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
	validator = FormValidation.formValidation(
		form,
		{
			fields: {
				
				user_name: {
					validators: {
						notEmpty: {
							message: 'Users Name is Required'
						}
					}
				},
                user_email: {
					validators: {
						notEmpty: {
							message: 'Users Email is Required'
						}
					}
				},
                user_role: {
					validators: {
						notEmpty: {
							message: 'Users Role is Required'
						}
					}
				},
				
				'targets_notifications[]': {
					validators: {
						notEmpty: {
							message: 'Please select at least one communication method'
						}
					}
				},
			},
			plugins: {
				trigger: new FormValidation.plugins.Trigger(),
				bootstrap: new FormValidation.plugins.Bootstrap5({
					rowSelector: '.fv-row',
					eleInvalidClass: '',
					eleValidClass: ''
				})
			}
		}
		
	);


}
$(document).on("click",".edit_user",function() {
    let data_id=$(this).attr('data-id');
	let uso_edit1=uso_edit.replace(':id',data_id);
	
	axios.get(uso_edit1, {
		'_method': 'GET',
		'dataType':'JSON'

	})
	.then(function(response) {
		response=(response.data);
		$('#kt_modal_new_target').modal('toggle');
		$('.add-label').html('Edit users');
		$('#user_name').val(response.data.name);
		$('#user_email').val(response.data.email);
		$('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="users_id" value="'+data_id+'" id="edit_users_id">');

	}).catch(function(error){

	});
});
$('#kt_modal_new_target').on('hidden.bs.modal', function () {
	  $('.add-label').html('Add users');
	  form.reset();
	  $('.image-input-wrapper').attr('style',"background-image: url('"+hostUrl+"admin/assets/media/avatars/upload.png')");
	  $('#append_div').empty();					
  })
$(document).on("click",".delete_user",function(e) {
	
	var data_id=$(this).attr('data-id');
	var uso_delete1=uso_delete.replace(':id',data_id);
	e.preventDefault();
	
	Swal.fire({
		title: 'Are you sure to delete this record?',
		showDenyButton: true,
	
		confirmButtonText: 'Yes',
		
	  }).then((result) => {
		/* Read more about isConfirmed, isDenied below */
		if (result.isConfirmed) {
			axios.delete(uso_delete1, {
				'_method': 'DELETE',
				'dataType':'JSON'
		
			})
			.then(function(response) {
				{
					response=(response.data)
					if(response.success){
					
						Swal.fire({
							text: response.message,
							icon: "success",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						}).then(function (result) {
							if (result.isConfirmed) {
								$("#users_table").DataTable().ajax.reload(null, false);
							}
						});
					}else{
						Swal.fire({
							text: response.message,
							icon: "danger",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-danger"
							}
						}).then(function (result) {
							if (result.isConfirmed) {
								$("#users_table").DataTable().ajax.reload(null, false);
							}
						});
					}
				};
			})
			.catch(function(error) {
				console.log(error);
			});
		} else if (result.isDenied) {
		  //Swal.fire('Changes are not saved', '', 'info')
		}
	  })
   

  




});
$(document).on("click","#add_users",function() {
    $('#kt_modal_new_target').modal('show');
});

$(document).on('submit',"#user_form",function(){
   
	var cid=($('#edit_users_id').val());
	var method;
	var action;
	$('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
	if(!cid){
		action=uso_store;
		handleForm();
	}else{
		action=uso_update;
		action=action.replace(':id',cid);
		handleFormEdit();
	}
   	if (validator) {
		// Validate form
		validator.validate().then(function (status) {
			$('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
			if (status === 'Valid') {
				// Send ajax request
				axios.post(action,new FormData(form))
				.then(function (response) {
					response=response.data;
					if(response.success){
						Swal.fire({
							text: response.message,
							icon: "success",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						}).then(function (result) {
							if (result.isConfirmed) {
								form.reset(); // Reset form	
								$('#kt_modal_new_target').modal('toggle');
								$('.image-input-wrapper').attr('style',"background-image: url('"+hostUrl+"admin/assets/media/avatars/upload.png')");
								$("#users_table").DataTable( ).ajax.reload(null, false);
							}
						});
					}
					
					
				})
				.catch(function (error) {
					console.log(error)
					let dataMessage = error.response.data.message;
					let dataErrors = error.response.data.errors;
					
					for (const errorsKey in dataMessage) {
						if (!dataErrors.hasOwnProperty(errorsKey)) 
						continue;
						dataMessage += "\r\n" + dataErrors[errorsKey];
						
					}

					if (error.response) {
						Swal.fire({
							text: dataMessage,
							icon: "error",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						});
					}
				})
				.then(function () {
					// always executed
					// Hide loading indication
					submitButton.removeAttribute('data-kt-indicator');

					// Enable button
					submitButton.disabled = false;
					
				});
             
			}else{
				
			}
          
		});

	}
    return false;
});

$(function() {
	sports_users.init();
	
	

  });