"use strict";
var form = document.querySelector('#venue_form');
var c_form = document.querySelector('#custom_day_slot_schedule');
var couching_form = document.querySelector('#kt_coaching_add');
var submitButton = document.querySelector('#kt_modal_new_target_submit');
var modal = $('#kt_modal_new_target');
var day_wise_table= $('#cutom_slot_table');
var cutom_couching_table= $('#cutom_couching_table');
var validator;
var validator_new;
var validator_couch;
var tagify;
var slots_slots = {
    init: function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        ! function() {
            const t = $("#venue_table");
            var table = $('#venue_table').DataTable({
                type: "GET",
                processing: true,
                  serverSide: true,
                  stateSave: true,
                  bDestroy: true,
                  bPaginate: true,
                  searching: false ,
                  showing: false ,
                  lengthChange: false ,
             
                ajax: {
                  url: ven_index,
                  data: function (d) {
                      d.category= $('select[name="court_category"]').find(":checked").val();
                      d.sports= $('select[name="court_sports"]').find(":checked").val();
                      d.court= $('select[name="court_court_id"]').find(":checked").val();
                    }
                },
               columns: [{data: 'DT_RowIndex', searchable: false, orderable: false},
                            {
                                data: 'sports.category.name',
                                name: 'sports'
                            }, 
                            {
                                data: 'sports.name',
                                name: 'sports'
                            },
                            {
                                data: 'name',
                                name: 'name'
                            },
                            {
                                data: 'image',
                                name: 'image'
                            },
                            {
                                data: 'slug',
                                name: 'slug'
                            },
                            {
                                data: 'action',
                                name: 'action',
                               
                            },
                            
                        ],
                        columnDefs: [{
                            targets: 4,
                            render: function(data) {
                                if (data) {
                                    //alert($('select[name="court_category"]').find(":checked").val());
                                    return '<img src="' + data + '">'
                                }
        
        
                            }
                        }]
            })
        }()
    },
    loadSlots:function(){
       
         axios.get(loadSlots, {
            '_method': 'GET',
            'dataType': 'HTML'

        })
        .then(function(response) {
          
            $('#append_time_sheet').empty().append(response.data);
            refreshTimePicker();
        }).catch(function(error) {

        });
    }, 
    dayWiseSlots:function(){
       
        day_wise_table.DataTable({

            ajax: court_custom_schedule,
            type: "GET",
            processing: true,
            serverSide: true,
            stateSave: true,
            bDestroy: true,
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'date',
                    name: 'date'
                }, 
                {
                    data: 'start_time',
                    name: 'start_time'
                },
                {
                    data: 'end_time',
                    name: 'end_time'
                },
                {
                    data: 'slot_break_time',
                    name: 'slot_break_time'
                },
                {
                    data: 'slot_duration',
                    name: 'slot_duration'
                },
                {
                    data: 'time_off',
                    name: 'time_off'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ]
        })
        
    },
    loadCoachingWeekday:function(){
     
        cutom_couching_table.DataTable({
            ajax: {
                url: get_couching_slots,
            },
            processing: true,
            serverSide: true,
            stateSave: true,
            bDestroy: true,
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'group',
                    name: 'group'
                },
             
                {
                    data: 'weekid',
                    name: 'weekid'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ],
            // columnDefs: [{
            //     targets: 4,
            //     render: function(data) {
            //         if (data) {

            //             return '<img src="' + data + '">'
            //         }


            //     }
            // }]

        })
        tagify = new Tagify(document.querySelector('#kt_tagify_country'), {
            delimiters: null,
            templates: {
                tag: function (tagData) {
                    const countryPath = 'assets/media/flags/' + tagData.value.toLowerCase().replace(/\s+/g, '-') + '.svg';
                    try {
                        // _ESCAPE_START_
                        return `<tag title='${tagData.value}' contenteditable='false' spellcheck="false"
                            class='tagify__tag ${tagData.class ? tagData.class : ""}' ${this.getAttributes(tagData)}>
                                <x title='remove tag' class='tagify__tag__removeBtn'></x>
                                <div class="d-flex align-items-center">
                                 
                                    <span class='tagify__tag-text'>${tagData.value}</span>
                                </div>
                            </tag>`
                        // _ESCAPE_END_
                    }
                    catch (err) { }
                },
        
                dropdownItem: function (tagData) {
                    const countryPath = 'assets/media/flags/' + tagData.value.toLowerCase().replace(/\s+/g, '-') + '.svg';
                    try {
                        // _ESCAPE_START_
                        return `<div class='tagify__dropdown__item ${tagData.class ? tagData.class : ""}'>
                                    <span>${tagData.value}</span>
                                </div>`
                        // _ESCAPE_END_
                    }
                    catch (err) { }
                }
            },
            enforceWhitelist: true,
            whitelist: [
                { value: 'Sunday', code: '0' },
                { value: 'Monday', code: '1' },
                { value: 'Tuesday', code: '2' },
                { value: 'Wednesday', code: '3' },
                { value: 'Thursday', code: '4' },
                { value: 'Friday', code: '5' },
                { value: 'Saturday', code: '6' },
            ],
            dropdown: {
                enabled: 1, // suggest tags after a single character input
                classname: 'extra-properties' // custom class for the suggestions dropdown
            } // map tags' values to this property name, so this property will be the actual value and not the printed value on the screen
        });
        
        // add the first 2 tags and makes them readonly
        //  var tagsToAdd = tagify.settings.whitelist.slice(0, 2);
        //  console.log(tagsToAdd);
        //  tagify.addTags(tagsToAdd);
       
    },


};

var handleForm = function() {

    // Stepper custom navigation
    $('.invalid-feedback').remove();
    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
    validator = FormValidation.formValidation(
        form, {
            fields: {

                venue_name: {
                    validators: {
                        notEmpty: {
                            message: 'Court Name is Required'
                        }
                    }
                },
                category_type: {
                    validators: {
                        notEmpty: {
                            message: 'Category Type is Required'
                        }
                    }
                },
                sports: {
                    validators: {
                        notEmpty: {
                            message: 'Sports is Required'
                        }
                    }
                },

                'targets_notifications[]': {
                    validators: {
                        notEmpty: {
                            message: 'Please select at least one communication method'
                        }
                    }
                },
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.fv-row',
                    eleInvalidClass: '',
                    eleValidClass: ''
                })
            }
        }

    );


}
var handleFormCustomSchedule = function() {

    // Stepper custom navigation
    $('.invalid-feedback').remove();
    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
    validator_new= FormValidation.formValidation(
        c_form, {
            fields: {

                day_date: {
                    validators: {
                        notEmpty: {
                            message: 'Date is required'
                        }
                    }
               },
               day_start_time: {
                validators: {
                    notEmpty: {
                        message: 'Start is required'
                    }
                }
                },
                day_end_time: {
                    validators: {
                        notEmpty: {
                            message: 'End is required'
                        }
                    }
                 },
                day_break_time: {
                validators: {
                    notEmpty: {
                        message: 'Date Break time is required'
                    }
                }
              },
              day_slot_duration: {
                validators: {
                    notEmpty: {
                        message: 'Date slot duration  is required'
                    }
                }
              },
              day_slot_price: {
                validators: {
                    notEmpty: {
                        message: 'Date slot Price  is required'
                    }
                }
              },

              
                // day_working_day: {
                //     validators: {
                //         notEmpty: {
                //             message: 'Please select, is it working day'
                //         }
                //     }
                // },
                
                'targets_notifications[]': {
                    validators: {
                        notEmpty: {
                            message: 'Please select at least one communication method'
                        }
                    }
                },
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.fv-row',
                    eleInvalidClass: '',
                    eleValidClass: ''
                })
            }
        }

    );


}
var handleFormCouching = function() {
   
    // Stepper custom navigation
    $('.invalid-feedback').remove();
    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
    validator_couch = FormValidation.formValidation(
        couching_form, {
            fields: {
                group_name: {
                    validators: {
                        notEmpty: {
                            message: 'Group name is required'
                        }
                    }
               },
                  days: {
                    validators: {
                        notEmpty: {
                            message: 'Weekday name required'
                        }
                    }
                },
                
                'targets_notifications[]': {
                    validators: {
                        notEmpty: {
                            message: 'Please select at least one communication method'
                        }
                    }
                },
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.fv-row',
                    eleInvalidClass: '',
                    eleValidClass: ''
                })
            }
        }

    );


}

$(document).on("click", ".edit_sports", function() {
    let data_id = $(this).attr('data-id');
    let c_edit = ven_edit.replace(':id', data_id);
   
    axios.get(c_edit, {
            '_method': 'GET',
            'dataType': 'JSON'

        })
        .then(function(response) {
            response = (response.data);
            $('#kt_modal_new_target').modal('toggle');
            $('.add-label').html('Edit Court');
            $('#venue_name').val(response.data.name);
            $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + response.data.image + "')");
            $('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="sports_id" value="' + data_id + '" id="edit_sports_id">');
           $('select[name="category_type"] option[value="'+response.date.sports_category+'"]').attr('selected', 'selected');
          
        }).catch(function(error) {

        });
});
$('#kt_modal_new_target').on('hidden.bs.modal', function() {
    $('.add-label').html('Add Timings');
    form.reset();
    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
    $('#append_div').empty();
})
$(document).on("click", ".delete_venue", function(e) {

    var data_id = $(this).attr('data-id');
    var ven_delete1 = ven_delete.replace(':id', data_id);
    e.preventDefault();

    Swal.fire({
        title: 'Are you sure to delete this record?',
        showDenyButton: true,

        confirmButtonText: 'Yes',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            axios.delete(ven_delete1, {
                    '_method': 'DELETE',
                    'dataType': 'JSON'

                })
                .then(function(response) {
                    {
                        response = (response.data)
                        if (response.success) {

                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#venue_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        } else {
                            Swal.fire({
                                text: response.message,
                                icon: "danger",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#venue_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }
                    };
                })
                .catch(function(error) {
                    console.log(error);
                });
        } else if (result.isDenied) {
            //Swal.fire('Changes are not saved', '', 'info')
        }
    })




});
$(document).on("click", "#add_sports", function() {
    $('#kt_modal_new_target').modal('show');
});

$(document).on('submit', "#venue_form", function() {
    var cid = ($('#edit_sports_id').val());
    var method;
    var action;
    if (!cid) {
        action = ven_store;
    } else {
        action = ven_update;
        action = action.replace(':id', cid);
    }
  
    $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
    handleForm();
  
    if (validator) {
        // Validate form
        validator.validate().then(function(status) {
            $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
            if (status === 'Valid') {
                // Send ajax request
                axios.post(action, new FormData(form))
                    .then(function(response) {
                        response = response.data;
                        if (response.success) {
                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    form.reset(); // Reset form	
                                    $('#kt_modal_new_target').modal('toggle');
                                    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
                                    $("#venue_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }


                    })
                    .catch(function(error) {
                        console.log(error)
                        let dataMessage = error.response.data.message;
                        let dataErrors = error.response.data.errors;

                        for (const errorsKey in dataMessage) {
                            if (!dataErrors.hasOwnProperty(errorsKey))
                                continue;
                            dataMessage += "\r\n" + dataErrors[errorsKey];

                        }

                        if (error.response) {
                            Swal.fire({
                                text: dataMessage,
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                        }
                    })
                    .then(function() {
                        // always executed
                        // Hide loading indication
                        submitButton.removeAttribute('data-kt-indicator');

                        // Enable button
                        submitButton.disabled = false;

                    });

            } else {

            }

        });

    }
    return false;
});

$(function() {
    slots_slots.init();
    slots_slots.loadSlots();
    slots_slots.dayWiseSlots();
});

$('select[name="category_type"]').on('change', function() {
    var cid=( $(this).find(":checked").val() );
    var ven_url=get_sports.replace(":id",cid);
    axios.get(ven_url, {
        '_method': 'GET',
        'dataType': 'JSON'

    })
    .then(function(response) {
        response = (response.data);
        var opt;
        $('select[name="sports"]').find('option')
        .remove().append('<option value="">Select Sports</option>');
        $.each(response.data, function (key, val) {
           
            $('select[name="sports"]')
            .append($("<option></option>")
                       .attr("value", val.id)
                       .text(val.name)); 
        });
      
    }).catch(function(error) {

    });
});

$(document).on("submit", "#time_schedule", function (e) {
    $('#add_schedule').attr('data-kt-indicator', 'on');
  axios({
        method: "post",
        url: save_slot,
        data: $('#time_schedule').serialize(),
      })
        .then(function (response) {
            $('#add_schedule').attr('data-kt-indicator', 'off');
            response = response.data;
            if (response.success) {
                Swal.fire({
                    text: response.message,
                    icon: "success",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                }).then(function(result) {
                    if (result.isConfirmed) {
                        slots_slots.loadSlots()
                    }
                });
            }
        })
        .catch(function (response) {
          //handle error
          console.log(response);
        
          let dataMessage = response.response.data.message;
          let dataErrors = response.response.data.errors;

           

            if (dataErrors) {
                Swal.fire({
                    text: dataMessage,
                    icon: "error",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                });
            }
        });
     return false;
});

$(document).on('change', 'input', function() {
    console.log($(this).parent().parent('td').parent('tr').find('.reset').attr('checked', true));
});

$(document).on('change', '.enable-golden-hour', function() {
    
    console.log($(this).parent().parent('td').parent('tr').find('.enable-golden-hour-price').attr('readonly', false));
});
  function loadDayTime(did,cid){
  
    var url=load_day_slot.replace(':id',did);
    url=url.replace(':cid',cid);;
    axios({
        method: "get",
        url: url
      })
        .then(function (response) {
            $('#kt_modal_new_target').modal('show');
            $('#time_slot_day_append').empty().append(response.data);
             if (response.success) {
                Swal.fire({
                    text: response.message,
                    icon: "success",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                }).then(function(result) {
                    if (result.isConfirmed) {
                       $('.reset').attr('checked', false);
                    }
                });
            }
        })
        .catch(function (response) {
          //handle error
          console.log(response);
        });
     return false;
  }

  $(document).on('submit','#custom_time_slot_form',function(){
    
    axios({
        method: "post",
        url: update_day_slot_time,
        data: $('#custom_time_slot_form').serialize(),
      })
        .then(function (response) {
         
            response = response.data;
            if (response.success) {
                Swal.fire({
                    text: response.message,
                    icon: "success",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                }).then(function(result) {
                    if (result.isConfirmed) {
                        $('#kt_modal_new_target').modal('toggle');
                    }
                });
            }
        })
        .catch(function (response) {
          //handle error
          console.log(response);
        });
     return false;
  
  });


  $(document).on('click','#add_custom_day',function(){
     $('#add_day_schedule').modal('show');
  });


  
  $(document).on('submit','#custom_day_slot_schedule',function(){
    handleFormCustomSchedule();
    var cid = ($('#edit_custom_time_id').val());
    var method;
    var action;
    if (!cid) {
        action = court_custom_schedule_save;
    } else {
        action = court_custom_schedule_update;
        action = action.replace(':id', cid);
    }
    if (validator_new) {
        // Validate form
        validator_new.validate().then(function(status) {
            if (status === 'Valid') {
            axios({
                method: "post",
                url: action,
                data: $('#custom_day_slot_schedule').serialize(),
              }).then(function (response) {
                response = response.data;
                alert(response.success)
                    if (response.success) {
                        Swal.fire({
                            text: response.message,
                            icon: "success",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn btn-primary"
                            }
                        }).then(function(result) {
                            if (result.isConfirmed) {
                                $('#add_day_schedule').modal('toggle');
                                $('#custom_day_slot_schedule').trigger('reset');
                                day_wise_table.DataTable().ajax.reload(null, false);
                            }
                        });
                    }else{
                        Swal.fire({
                            text: response.message,
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn btn-primary"
                            }
                        }).then(function(result) {
                            
                        });
                    }
                })
                .catch(function (error) {
					console.log(error)
					let dataMessage = error.response.data.message;
					let dataErrors = error.response.data.errors;
					
					for (const errorsKey in dataMessage) {
						if (!dataErrors.hasOwnProperty(errorsKey)) 
						continue;
						dataMessage += "\r\n" + dataErrors[errorsKey];
						
					}
                   
					if (error.response) {
						Swal.fire({
							text: dataMessage,
							icon: "error",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						});
					}
				})
            }
        });

    }
   
     return false;
  
  });

  $(document).on('click','.edit_custom_time',function(){
        let data_id = $(this).attr('data-id');
        court_custom_schedule_edit = court_custom_schedule_edit.replace(':id', data_id);
        axios.get(court_custom_schedule_edit, {
                '_method': 'GET',
                'dataType': 'JSON'
             })
            .then(function(response) {
                response = (response.data);
                $('#append_div_custom_time').append('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="cus_slot_id" value="' + data_id + '" id="edit_custom_time_id">');
                $('#add_day_schedule').modal('toggle');
                $('.add-label').html('Edit Timing1');
                $('#day_date').val(response.data.date);
                $('#day_start_time').val(response.data.start_time);
                $('#day_end_time').val(response.data.end_time);
                $('#day_break_time').val(response.data.slot_break_time);
                $('#day_slot_duration').val(response.data.slot_duration);
                $('#day_slot_price').val(response.data.price_per_slot);
               $('select[name="category_type"] option[value="'+response.date.sports_category+'"]').attr('selected', 'selected');
             }).catch(function(error) {
    
            });
            return false;
  });
  
  
  $(document).on("click", ".delete_custom_time", function(e) {
    var data_id = $(this).attr('data-id');
    var court_custom_schedule_delete1 = court_custom_schedule_delete.replace(':id', data_id);
    e.preventDefault();
        Swal.fire({
        title: 'Are you sure to delete this record?',
        showDenyButton: true,

        confirmButtonText: 'Yes',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            axios.delete(court_custom_schedule_delete1, {
                    '_method': 'DELETE',
                    'dataType': 'JSON'

                })
                .then(function(response) {
                    {
                        response = (response.data)
                        if (response.success) {

                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    day_wise_table.DataTable().ajax.reload(null, false);
                                }
                            });
                        } else {
                            Swal.fire({
                                text: response.message,
                                icon: "danger",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    day_wise_table.DataTable().ajax.reload(null, false);
                                }
                            });
                        }
                    };
                })
                .catch(function(error) {
                    console.log(error);
                });
        } else if (result.isDenied) {
            //Swal.fire('Changes are not saved', '', 'info')
        }
    })




});


$(document).on("click",".show_custom_time",function(e){
    var did= $(this).attr('data-id');
    var url=court_timeing_slots_edit.replace(':id',did);
    axios({
        method: "get",
        url: url
    }).then(function (response) {
            $('#kt_custom_day_timing_edit_modal').modal('show');
            $('#custom_time_slot_day_append').empty().append(response.data);
            if (response.success) {
                Swal.fire({
                    text: response.message,
                    icon: "success",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                }).then(function(result) {
                    if (result.isConfirmed) {
                    $('.reset').attr('checked', false);
                    }
                });
            }
        })
        .catch(function (response) {
            let dataMessage = error.response.data.message;
         
            let dataErrors = error.response.data.errors;

            for (const errorsKey in dataMessage) {
                if (!dataErrors.hasOwnProperty(errorsKey))
                    continue;
                dataMessage += "\r\n" + dataErrors[errorsKey];

            }
           
            if (error.response) {
                Swal.fire({
                    text: dataMessage,
                    icon: "error",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                });
            }
        console.log(response);
        });
    return false;
});

$(document).on('submit','#custom_day_time_slot_form',function(){
    
    axios({
        method: "post",
        url: court_timeing_slots_update,
        data: $('#custom_day_time_slot_form').serialize(),
      })
        .then(function (response) {
         
            response = response.data;
            if (response.success) {
                Swal.fire({
                    text: response.message,
                    icon: "success",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                }).then(function(result) {
                    if (result.isConfirmed) {
                        $('#kt_custom_day_timing_edit_modal').modal('toggle');
                    }
                });
            }else{
                Swal.fire({
                    text: response.message,
                    icon: "warning",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                });
            }
        })
        .catch(function (data) {
            var response=data.response;
            let dataMessage = response.data.message;
           if (dataMessage) {
                 Swal.fire({
                     text: dataMessage,
                     icon: "error",
                     buttonsStyling: false,
                     confirmButtonText: "Ok, got it!",
                     customClass: {
                         confirmButton: "btn btn-primary"
                     }
                 });
             }
        });
     return false;
  
  });


  $(document).on('click','#add_couching',function(){
        $('#kt_coaching_add').modal('show');
  });

  $(document).on('click','#add_couching',function(){
    $('#kt_coaching_add').modal('show');
  });

 
  
  $(document).on('click','.show_coaching_time',function(){
      var data_id=$(this).attr('data-id');
      var url=load_couching_timings.replace(':id',data_id);
      axios({
        method: "get",
        url: url
      }).then(function (response) {
            $('#kt_coaching_time_assign_model').modal('show');
            $('#append_coachingtime').empty().append(response.data);
            if (response.success) {
                Swal.fire({
                    text: response.message,
                    icon: "success",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                }).then(function(result) {
                    if (result.isConfirmed) {
                    $('.reset').attr('checked', false);
                    }
                });
            }
        })
        .catch(function (response) {
        //handle error
        console.log(response);
        });
    return false;
  });
  
  $(document).on('click','.add_couching_time',function(){
    axios({
        method: "get",
        url: load_tr
      }).then(function (response) {
            if (response) {
                $('#couching_court_timings tr:last').before(response.data);
            }
        })
        .catch(function (response) {
        //handle error
        console.log(response);
        });
   });

   $(document).on('click','.add_custom_time',function(){
   
    axios({
        method: "get",
        url: custom_slots_quick_load_tr
      }).then(function (response) {
            if (response) {
                $('#custom_table_id tr:last').before(response.data);
            }
        })
        .catch(function (response) {
        //handle error
        console.log(response);
        });
   });

  $(document).on('submit','#couching_time_schedule_form',function(){
   axios({
        method: "post",
        url: save_couching_timings,
        data: $('#couching_time_schedule_form').serialize(),
      })
        .then(function (response) {
          response = response.data;
            if (response.success) {
                Swal.fire({
                    text: response.message,
                    icon: "success",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                }).then(function(result) {
                    if (result.isConfirmed) {
                       // $('#kt_custom_day_timing_edit_modal').modal('toggle');
                    }
                });
            }
        })
        .catch(function (data) {
            var response=data.response;
            let dataMessage = response.data.message;
           if (dataMessage) {
                 Swal.fire({
                     text: dataMessage,
                     icon: "error",
                     buttonsStyling: false,
                     confirmButtonText: "Ok, got it!",
                     customClass: {
                         confirmButton: "btn btn-primary"
                     }
                 });
             }
        });
     return false;
  
  });


  $(document).on('click','#initial_tr_load',function(){
    $('#kt_modal_initial_load').modal('show');
  });

 
  $(document).on('submit','#quick_load_tr_from',function(){
    axios({
        method: "post",
        url: quick_load_tr,
        data: $('#quick_load_tr_from').serialize(),
      })
        .then(function (response) {
         
            if (response) {
                $('#couching_court_timings tr:last').before(response.data);
                $('#kt_modal_initial_load').modal('toggle');
            }
        })
        .catch(function (response) {
          //handle error
          console.log(response);
        });
     return false;
  
  });
  $(document).on('click','.delete_couching_row',function(){
    console.log($(this).parents('tr').remove());
});

  

$('select[name="court_category"]').on('change', function() {
    var cid=( $(this).find(":checked").val() );
    var ven_url=get_sports.replace(":id",cid);
    axios.get(ven_url, {
        '_method': 'GET',
        'dataType': 'JSON'

    })
    .then(function(response) {
        response = (response.data);
        $('select[name="court_sports"]').find('option').remove();
       
        var option="<option></option>";
        $.each(response.data, function (key, val) {
            option+="<option value="+val.id+">"+val.name+"</option>";
                     
        });
       // alert(option);
        $('select[name="court_sports"]').append(option);

    }).catch(function(error) {

    });
});

$('select[name="court_sports"]').on('change', function() {
   
    var cid=( $(this).find(":checked").val() );
   // $('select[name="court_sports"]').find('option').remove();
    var get_courts2=get_courts.replace(":id",cid);
    axios.get(get_courts2, {
        '_method': 'GET',
        'dataType': 'JSON'

    })
    .then(function(response) {
        response = (response.data);
        var opt;
        $('select[name="court_court_id"]').find('option')
        .remove();
        var opt="<option></option>";
        $.each(response.data, function (key, val) {
          
            opt+="<option value="+val.id+">"+val.name+"</option>";
        });

        $('select[name="court_court_id"]').append(opt); 
                 
    }).catch(function(error) {

    });
});

$('#court-filter-form').submit(function(){

    $("#venue_table").DataTable().ajax.reload(null, false);
    return false;

});





$(document).on('click','.edit_coaching_time',function(){
      
    let data_id = $(this).attr('data-id');
  
    var url = edit_coaching_session_time.replace(':id', data_id);
   
    axios.get(url, {
            '_method': 'GET',
            'dataType': 'JSON'

        })
        .then(function(response) {
            response = (response.data);
            tagify.removeAllTags();
            $('#kt_coaching_add').modal('toggle');
            $('.add-label').html('Edit Coaching Session');
            $('#group_name').empty().val(response.data.group);
            let tagsToAdd = tagify.settings.whitelist;
            let x=response.data.weekid;
            tagsToAdd=tagsToAdd.filter((el,i)=>x.some(j => i === parseInt(j)));
           // console.log(tagsToAdd);
            tagify.addTags(tagsToAdd);
            
            $('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="coaching_session_id" value="' + response.data.id + '" id="coaching_session_id"><input type="hidden" name="court_id" value="' + response.data.court_id + '" id="court_id">');
            
           
        }).catch(function(error) {

        });
        return false;
});

$(document).on('submit','#coaching_form',function(){
    handleFormCouching();
    var cid = ($('#coaching_session_id').val());
    var court_id = ($('#court_id').val());
    var action;
    if (!cid) {
        action = save_couching_slots;
    } else {
        action = update_coaching_session;
        action = action.replace(':id', cid);
        action = action.replace(':cid', court_id);
    }
    if (validator_couch) {
        // Validate form
        validator_couch.validate().then(function(status) {
           // alert(status);
           if (status === 'Valid') {
            if(status=='Valid'){
                axios({
                    method: "post",
                    url: action,
                    data: $('#coaching_form').serialize(),
                })
                    .then(function (response) {
                        response = response.data;
                        if (response.success) {
                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $('#coaching_form').trigger('reset');
                                    $('#kt_coaching_add').modal('toggle');
                                    cutom_couching_table.DataTable().ajax.reload(null, false);
                                }
                            });
                        }else{
                            Swal.fire({
                                text: response.message,
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                
                            });
                        }
                    })
                    .catch(function (data) {
                       var response=data.response;
                       let dataMessage = response.data.message;
                      
                        if (dataMessage) {
                            Swal.fire({
                                text: dataMessage,
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                        }
                 
                    });
            }
        }  
                });
            }
     return false;
  
  });
  