
@extends('layouts.admin.app')
@push('styles')
    <!--begin::Vendor Stylesheets(used by this page)-->
    <link href="{{ asset('admin/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('admin/assets/css/wickedpicker.min.css') }}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-timepicker/0.5.2/css/bootstrap-timepicker.min.css"
        integrity="sha512-/Ae8qSd9X8ajHk6Zty0m8yfnKJPlelk42HTJjOHDWs1Tjr41RfsSkceZ/8yyJGLkxALGMIYd5L2oGemy/x1PLg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        <!--end::Vendor Stylesheets
        -->
        #preloader
        {
        position:
        fixed;
        top:
        0;
        left:
        0;
        right:
        0;
        bottom:
        0;
        background-color:
        #fff;
        background-image:
        url(./assets/media/logos/1495.gif);
        /*
        path
        to
        your
        loading
        animation
        */
        background-repeat:
        no-repeat;
        background-position:
        center;
        /*
        change
        if
        the
        mask
        should
        have
        another
        color
        then
        white
        */
        z-index:
        99;
        /*
        makes
        sure
        it
        stays
        on
        top
        */
        }
        #status
        {
        width:
        200px;
        height:
        200px;
        position:
        absolute;
        left:
        50%;
        /*
        centers
        the
        loading
        animation
        horizontally
        one
        the
        screen
        */
        top:
        50%;
        /*
        centers
        the
        loading
        animation
        vertically
        one
        the
        screen
        */
        background-image:
        url('{{ asset('admin/assets/1495.gif') }}');
        /*
        path
        to
        your
        loading
        animation
        */
        background-repeat:
        no-repeat;
        background-position:
        center;
        margin:
        -100px
        0
        0
        -100px;
        /*
        is
        width
        and
        height
        divided
        by
        two
        */
        }
    </style>
@endpush

@section('title')
    <title>Schedule Time</title>
@endsection
@section('content')
    <!--begin::Modal - New Target-->
    <div class="modal fade" id="kt_modal_new_target" tabindex="-1" aria-hidden="true">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-1000px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">

                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2"
                                    rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>

                    </div>

                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->
                    <form id="custom_time_slot_form" class="form">

                        <div class="mb-13 text-center">
                            <h1 class="mb-3">Set Custom Price</h1>
                        </div>

                        <div class="scroll h-400px px-5" height="400" id="time_slot_day_append">

                        </div>
                        <div class="text-center">
                            <button type="reset" id="kt_modal_new_target_cancel"
                                class="btn btn-light me-3">Cancel</button>
                            <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                <span class="indicator-label">Save</span>
                                <span class="indicator-progress">Please wait...
                                    <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                            </button>
                        </div>

                    </form>
                    <!--end:Form-->
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - New Target-->

    <!--begin::Modal - New Target-->
    <div class="modal fade" id="kt_custom_day_timing_edit_modal" tabindex="-1" aria-hidden="true">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-800px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">

                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2"
                                    rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>

                    </div>

                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->
                    <form id="custom_day_time_slot_form" class="form">

                        <div class="mb-13 text-center">
                            <h1 class="mb-3">Set Day Custom Price</h1>
                        </div>

                        <div class="scroll h-400px px-5" height="400" id="custom_time_slot_day_append">

                        </div>
                        <div class="text-center">
                            <button type="reset" id="kt_modal_new_target_cancel"
                                class="btn btn-light me-3">Cancel</button>
                            <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                <span class="indicator-label">Save</span>
                                <span class="indicator-progress">Please wait...
                                    <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                            </button>
                        </div>

                    </form>
                    <!--end:Form-->
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - New Target-->

    <!--begin::Modal - New Target-->
    <div class="modal fade" id="kt_coaching_add" tabindex="-1" aria-hidden="true">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-600px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">

                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2"
                                    rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>

                    </div>

                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->

                    <form id="coaching_form" class="form" enctype="multipart/form-data"
                        action="{{ route('admin.categories.store') }}" method="POST">
                        <div class="mb-13 text-center">
                            <h1 class="mb-3 add-label">Add Coaching</h1>
                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Group Name</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter sports"></i>
                            </label>
                            <input type="text" class="form-control form-control-solid"
                                placeholder="Enter Target Title" name="group_name" id="group_name" />
                            <div id="append_div"></div>
                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Select Days</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter sports"></i>
                            </label>
                            <input class="form-control d-flex align-items-center" id="kt_tagify_country"
                                name="days" />
                            <div id="append_div"></div>
                        </div>
                        @csrf()

                        <div class="text-center">
                            <button type="reset" id="kt_modal_new_target_cancel"
                                class="btn btn-light me-3">Cancel</button>
                            <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                <span class="indicator-label">Submit</span>
                                <span class="indicator-progress">Please wait... <span
                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>
                        </div>
                    </form>



                    <!--end:Form-->
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - New Target-->

    <!--begin::Modal - New Target-->
    <div class="modal fade" id="kt_coaching_time_assign_model" tabindex="-1" aria-hidden="true">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-1000px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">

                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2"
                                    rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>

                    </div>

                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <div class="mb-13 text-center">
                        <h1 class="mb-3 add-label">Add Timings</h1>
                        <button type="button" id="initial_tr_load">Load</button>

                    </div>
                    <!--begin:Form-->
                    <div id="append_coachingtime"></div>
                    <!--end:Form-->
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - New Target-->

      <!--begin::Modal - New Target-->
    <div class="modal fade" id="kt_modal_initial_load" tabindex="-1" aria-hidden="true">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-400px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">

                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2"
                                    rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>

                    </div>

                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->
                    <form id="quick_load_tr_from" class="form">
                        <div class="row">
                            <div class="col">
                                <div class="d-flex flex-column mb-4 fv-row">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Start Time</span>
                                        <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                            title="Please start time"></i>
                                    </label>
                                    <input type="time" class="form-control" name="start_time" >
                                </div>
                            </div>
                            <div class="col">
                                <div class="d-flex flex-column mb-4 fv-row">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">End Time</span>
                                        <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                            title="Please end time"></i>
                                    </label>
                                    <input type="time" class="form-control" name="end_time" >
                                </div>
                            </div>
                        </div>
                   
                       
                        <div class="row">
                            <div class="col">
                                    <div class="d-flex flex-column mb-8 fv-row">
                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                            <span class="required">Break Time</span>
                                            <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                                title="Please break time"></i>
                                        </label>
                                        <input type="text" class="form-control" name="breaktime" >
                                    </div>
                            </div>
                            <div class="col">
                                    <div class="d-flex flex-column mb-8 fv-row">
                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                            <span class="required">Customer Type</span>
                                            <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                                title="Please break time"></i>
                                        </label>
                                        <select class="form-select form-select" name="customer_type">
                                            @foreach($player_type as $_data)
                                            <option value="{{$_data->id}}">{{$_data->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col">
                                <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Hour Per Slot</span>
                                    <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                        title="Please break time"></i>
                                </label>
                                    <input type="text" class="form-control" name="hours" >
                                </div>
                            </div>
                            <div class="col">
                            <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Price Per Slot</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please break time"></i>
                            </label>
                            <input type="text" class="form-control" name="price" >
                            </div>
                            </div>
                       </div>
                       <div class="row">
                            <div class="col">
                                <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Max Join</span>
                                    <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                        title="Please break time"></i>
                                </label>
                                    <input type="text" class="form-control" name="max_join" >
                                </div>
                            </div>
                            <div class="col">
                            <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Status</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please break time"></i>
                            </label>
                            <div class="form-check form-switch">
                                
                              <input class="form-check-input" type="checkbox" name="status"  role="switch" id="flexSwitchCheckChecked">
                           </div>
                            </div>
                            </div>
                        </div>
                            <div class="text-center">
                                <button type="reset" id="kt_modal_new_target_cancel"
                                    class="btn btn-light me-3">Cancel</button>
                                <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                    <span class="indicator-label">Load</span>
                                    <span class="indicator-progress">Please wait...
                                        <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                </button>
                            </div>
                       
                      
                    </form>
                    <!--end:Form-->
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
    <!--end::Modal - New Target-->

    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">

        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">

            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">

                <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                    Court</h1>

                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">

                    <li class="breadcrumb-item text-muted">
                        <a href="#" class="text-muted text-hover-primary">Home</a>
                    </li>


                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-400 w-5px h-2px"></span>
                    </li>


                    <li class="breadcrumb-item text-muted">Time Schedule</li>

                </ul>

            </div>
            <!-- <div class="d-flex align-items-center gap-2 gap-lg-3">



                            <a href="#" class="btn btn-sm fw-bold btn-primary" id="add_sports">Add Venue</a>

                        </div> -->

        </div>

    </div>



    <div id="preloader">

    </div>
    <div id="" class="app-content flex-column-fluid">

        <div id="" class="app-container container-fluid">

            <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
                <div class="col-xxl-12">
                    <ul class="nav nav-tabs nav-line-tabs nav-line-tabs-2x mb-5 fs-6">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#kt_coaching">Coaching</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#kt_weekwise">Weekwise</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#kt_daywise">Daywise</a>
                        </li>

                    </ul>

                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="kt_coaching" role="tabpanel">
                            <div class="card card-flush mt-2">

                                <div class="card-header mt-5">

                                    <div class="card-title flex-column">
                                        <button type="button" id="add_couching"
                                            class="btn btn-sm fw-bold btn-primary">Add Coaching</button>
                                    </div>

                                </div>

                                <div class="card-body pt-0">
                                    <div class="table-responsive">

                                        <table id="cutom_couching_table"
                                            class="table table-row-bordered table-row-dashed gy-4 align-middle fw-bold">
                                            <thead class="fs-7 text-gray-400 text-uppercase">
                                                <tr>
                                                    <th class="min-w-50px">Id</th>
                                                    <th class="min-w-50px">Group Name</th>
                                                    <th class="min-w-50px">Weekdays</th>
                                                    <th class="min-w-50px">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody class="fs-6">

                                            </tbody>

                                        </table>

                                    </div>

                                </div>

                            </div>
                        </div>
                        <div class="tab-pane fade show" id="kt_weekwise" role="tabpanel">
                            <div class="card card-flush mt-2">

                                <div class="card-header mt-5">

                                    <div class="card-title flex-column">
                                        <h3 class="fw-bold mb-1">Week Based</h3>
                                    </div>
                                </div>

                                <div class="card-body pt-0" id="append_time_sheet">


                                </div>

                            </div>
                        </div>
                        <div class="tab-pane fade" id="kt_daywise" role="tabpanel">
                            <div class="card card-flush mt-2">

                                <div class="card-header mt-5">

                                    <div class="card-title flex-column">
                                        <button type="button" id="add_custom_day"
                                            class="btn btn-sm fw-bold btn-primary">Add Day</button>
                                    </div>

                                </div>

                                <div class="card-body pt-0">
                                    <div class="table-responsive">

                                        <table id="cutom_slot_table"
                                            class="table table-row-bordered table-row-dashed gs-3 align-middle fw-bold">

                                            <thead class="fs-7 text-gray-400 text-uppercase">
                                                <tr>
                                                    <th class="min-w-50px">Id</th>
                                                    <th class="min-w-50px">Date</th>
                                                    <th class="min-w-50px">Start Time</th>
                                                    <th class="min-w-50px">End Time</th>
                                                    <th class="min-w-50px">Break (Min)</th>
                                                    <th class="min-w-50px">Slot (Hr)</th>
                                                    <th class="min-w-50px">Working Day</th>
                                                    <th class="min-w-100px">Action</th>

                                                </tr>
                                            </thead>
                                            <tbody class="fs-6">

                                            </tbody>

                                        </table>

                                    </div>

                                </div>

                            </div>
                        </div>

                    </div>


                </div>

            </div>


        </div>
    </div>
@endsection
@section('modal')
    <div class="modal fade" id="add_day_schedule" tabindex="-1" role="dialog">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-650px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2"
                                    rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->
                    <form id="custom_day_slot_schedule" class="form" enctype="multipart/form-data"
                        action="{{ route('admin.sports.store') }}" method="POST">
                        <div class="mb-13 text-center">
                            <h1 class="mb-3 add-label">Add Slot</h1>
                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Date</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please select date"></i>
                            </label>
                            <input type="date" class="form-control form-control-solid" placeholder="Please Enter Date"
                                name="day_date" id="day_date" />

                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Start Time</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter day start time"></i>
                            </label>
                            <input type="time" class="form-control form-control-solid"
                                placeholder="Please enter start time" name="day_start_time" id="day_start_time" />

                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">End Time</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter day end time"></i>
                            </label>
                            <input type="time" class="form-control form-control-solid"
                                placeholder="Please enter end time" name="day_end_time" id="day_end_time" />

                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Break ( Min )</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter break time"></i>
                            </label>
                            <input type="text" class="form-control form-control-solid"
                                placeholder="Please enter break time" name="day_break_time" id="day_break_time" />

                        </div>

                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Slot Duration ( Hr )</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter slot duration"></i>
                            </label>
                            <input type="text" class="form-control form-control-solid"
                                placeholder="Please enter slot duration" name="day_slot_duration"
                                id="day_slot_duration" />

                        </div>
                        <div id="append_div_custom_time"></div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Price</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter price per slot"></i>
                            </label>
                            <input type="text" class="form-control form-control-solid"
                                placeholder="Please enter price per slot" name="day_slot_price" id="day_slot_price" />

                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Working Day</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter slot duration"></i>
                            </label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="day_working_day" role="switch"
                                    id="flexSwitchCheckChecked" checked="">
                            </div>

                        </div>





                        @csrf()

                        <div class="text-center">
                            <button type="reset" id="kt_modal_new_target_cancel"
                                class="btn btn-light me-3">Cancel</button>
                            <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                <span class="indicator-label">Submit</span>
                                <span class="indicator-progress">Please wait... <span
                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>
                        </div>
                    </form>


                    <!--end:Form-->
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
@endsection
@push('scripts')
    <script>
        var ven_index = '{{ route('admin.venues.index') }}';
        var ven_edit = '{{ route('admin.venues.edit', ':id') }}';
        var ven_delete = '{{ route('admin.venues.destroy', ':id') }}';
        var ven_store = '{{ route('admin.venues.store') }}';
        var ven_update = '{{ route('admin.venues.update', ':id') }}';
        var get_sports = '{{ route('admin.get-sports', ':id') }}';
        var court_id = '{{ $court_id }}';
        var loadSlots = '{{ route('admin.load-timings', $court_id) }}';
        var save_slot = '{{ route('admin.save-court-time-schedule', $court_id) }}';
        var load_day_slot = '{{ route('admin.load-day-timings', [':id', ':cid']) }}';
        var update_day_slot_time = '{{ route('admin.update-day-time') }}';
        var court_custom_schedule = '{{ route('admin.court-custom-schedule', $court_id) }}';
        var court_custom_schedule_save = '{{ route('admin.court-custom-schedule-save', $court_id) }}';
        var court_custom_schedule_edit = '{{ route('admin.court-custom-schedule-edit', ':id') }}';
        var court_custom_schedule_update = '{{ route('admin.court-custom-schedule-update', ':id') }}';
        var court_custom_schedule_delete = '{{ route('admin.court-custom-schedule-delete', ':id') }}';
        var court_timeing_slots_edit = '{{ route('admin.court-timeing-slots-edit', ':id') }}';
        var court_timeing_slots_update = '{{ route('admin.court-timeing-slots-update', ':id') }}';
        var get_couching_slots = '{{ route('admin.get-couching-slots', $court_id) }}';
        var save_couching_slots = '{{ route('admin.save-couching-slots', $court_id) }}';
        var load_couching_timings = '{{ route('admin.load-couching-slots-timing', ':id') }}';
        var save_couching_timings = '{{ route('admin.save-couching-slots-timing', $court_id) }}';
        var load_tr = '{{ route('admin.load-couching-slots-timing-tr') }}'; 
        var quick_load_tr = '{{ route('admin.quick-load-couching-slots-timing-tr') }}'; 
        var edit_coaching_session_time = '{{ route('admin.edit-coaching-session', ':id') }}'; 
        var update_coaching_session = '{{ route('admin.update-couching-slots',[':cid', ':id']) }}'; 

        var custom_slots_quick_load_tr = '{{ route('admin.load-custom-slots-timing-tr') }}'; 

        
        
        
    </script>
    <script src="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-timepicker/0.5.2/js/bootstrap-timepicker.min.js"
        integrity="sha512-2xXe2z/uA+2SyT/sTSt9Uq4jDKsT0lV4evd3eoE/oxKih8DSAsOF6LUb+ncafMJPAimWAXdu9W+yMXGrCVOzQA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script src="{{ asset('admin/assets/js/custom/apps/venues/venues.js') }}"></script>
    <script>
        $(window).on('load', function() {
            $('#preloader').delay(400).fadeOut('5000');
            $('body').delay(350).css({
                'overflow': 'visible'
            });
        });
    </script>

    <script>
        slots_slots.loadCoachingWeekday();
    </script>
@endpush
