
@extends('layouts.admin.app')
@push('styles')
    <!--begin::Vendor Stylesheets(used by this page)-->
    <link href="{{ asset('admin/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <!--end::Vendor Stylesheets-->
@endpush
@section('title')
    <title>Dashboard</title>
@endsection
@section('content')
    <!--begin::Toolbar-->
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
        <!--begin::Toolbar container-->
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
            <!--begin::Page title-->
            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">

                <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">Default</h1>

                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                    <li class="breadcrumb-item text-muted">
                        <a href="../../demo1/dist/index.html" class="text-muted text-hover-primary">Home</a>
                    </li>
                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-400 w-5px h-2px"></span>
                    </li>
                    <li class="breadcrumb-item text-muted">Dashboards</li>
                </ul>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">
        <div id="kt_app_content_container" class="app-container container-fluid">
            <div class="row">
                <div class="row mb-5 mb-xl-10 col-lg-12">
                    <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3 mb-5">
                        <!-- <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="background-color: #febf00; background: url(assets/media/patterns/vector-1.png) #febf00 no-repeat bottom right; box-shadow: 0px 8px 0px 0px rgb(221 167 2); "> -->

                        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="box-shadow: rgba(0, 0, 0, 0.45) 0px 15px 20px -20px; border-bottom:5px solid #f88f4b">

                            <div class="card-header pt-5 pb-5" style="min-height: 130px;">
                                <div class="card-title d-flex flex-column">
                                    <span class="fs-2hx fw-bold me-2 lh-1 ls-n2">{{ $total_book_count }}</span>
                                    <span class="opacity-75 pt-4 fw-semibold fs-4">Total Booking</span>
                                </div>
                                <div class="d-flex flex-center rounded-circle h-60px w-60px"
                                    style="border: 1px dashed #f88f4b ">
                                    <i class="fonticon-incoming-call fs-2x lh-0" style="color:#f88f4b"></i>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3 mb-5">
                        <!-- <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="background-color: #a7303b; background: url(assets/media/patterns/vector-1.png) #a7303b no-repeat bottom right; box-shadow:0px 8px 0px 0px rgb(135 20 31) "> -->

                        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="box-shadow: rgba(0, 0, 0, 0.45) 0px 15px 20px -20px; border-bottom:5px solid #26b4c7">

                            <div class="card-header pt-5 pb-5" style="min-height: 130px;">
                                <div class="card-title d-flex flex-column">
                                    <span class="fs-2hx fw-bold me-2 lh-1 ls-n2">{{ $today_book_count }}</span>
                                    <span class="opacity-75 pt-4 fw-semibold fs-4">Today Booking</span>
                                </div>
                                <div class="d-flex flex-center rounded-circle h-60px w-60px"
                                    style="border: 1px dashed #26b4c7;">
                                    <i class="fonticon-mobile-payment fs-2x lh-0" style="color:#26b4c7"></i>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3 mb-5">

                        <!-- <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="background-color: #c30012 ; background: url(assets/media/patterns/vector-1.png) #c30012  no-repeat bottom right; box-shadow:0px 8px 0px 0px rgb(161 0 15)"> -->

                        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="box-shadow: rgba(0, 0, 0, 0.45) 0px 15px 20px -20px; border-bottom:5px solid #2d6df6">

                            <div class="card-header pt-5 pb-5" style="min-height: 130px;">
                                <div class="card-title d-flex flex-column">
                                    <span class="fs-2hx fw-bold me-2 lh-1 ls-n2">{{ $cus_count }}</span>
                                    <span class="opacity-75 pt-4 fw-semibold fs-4">Number of players</span>
                                </div>
                                <div class="d-flex flex-center rounded-circle h-60px w-60px"
                                    style="border: 1px dashed #2d6df6">
                                    <i class="fonticon-user fs-2x lh-0" style="color:#2d6df6"></i>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3 mb-5">

                        <!-- <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="background-color: #1ea13a;  background: url(assets/media/patterns/vector-1.png) #1ea13a no-repeat bottom right; box-shadow:0px 8px 0px 0px rgb(16 126 40)"> -->

                        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="box-shadow: rgba(0, 0, 0, 0.45) 0px 15px 20px -20px; border-bottom:5px solid #673ee3">

                            <div class="card-header pt-5 pb-5" style="min-height: 130px;">
                                <div class="card-title d-flex flex-column">
                                    <span class="fs-2hx fw-bold tme-2 lh-1 ls-n2">{{ $mem_count }}</span>
                                    <span class="opacity-75 pt-4 fw-semibold fs-4">Membership Players</span>
                                </div>
                                <div class="d-flex flex-center rounded-circle h-60px w-60px"
                                    style="border: 1px dashed #673ee3">
                                    <i class="fonticon-user-2 fs-2x lh-0" style="color:#673ee3"></i>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3 mb-5">
                        <!-- <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="background-color: #dfaf20; background: url(assets/media/patterns/vector-1.png) #dfaf20 no-repeat bottom right; box-shadow:0px 8px 0px 0px rgb(179 137 12)"> -->


                        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="box-shadow: rgba(0, 0, 0, 0.45) 0px 15px 20px -20px; border-bottom:5px solid #369344">

                            <div class="card-header pt-5 pb-5" style="min-height: 130px;">
                                <div class="card-title d-flex flex-column">
                                    <span class="fs-2hx fw-bold me-2 lh-1 ls-n2"> {{ $total_booking_revenue }}</span>
                                    <span class="opacity-75 pt-4 fw-semibold fs-4">Total Revenue</span>
                                </div>
                                <div class="d-flex flex-center rounded-circle h-60px w-60px"
                                    style="border: 1px dashed #369344">
                                    <i class="fonticon-cash-payment fs-2x lh-0" style="color:#369344"></i>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3 mb-5">
                        <!-- <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="background-color: #39a2c0; background: url(assets/media/patterns/vector-1.png) #39a2c0 no-repeat bottom right; box-shadow:0px 8px 0px 0px rgb(20 109 135)"> -->

                        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="box-shadow: rgba(0, 0, 0, 0.45) 0px 15px 20px -20px; border-bottom:5px solid #ed1e24">

                            <div class="card-header pt-5 pb-5" style="min-height: 130px;">
                                <div class="card-title d-flex flex-column">
                                    <span class="fs-2hx fw-bold me-2 lh-1 ls-n2">{{ $today_booking_revenue }}</span>
                                    <span class="opacity-75 pt-4 fw-semibold fs-4">Today Revenue</span>
                                </div>
                                <div class="d-flex flex-center rounded-circle h-60px w-60px"
                                    style="border: 1px dashed #ed1e24">
                                    <i class="fonticon-cash-payment fs-2x lh-0" style="color:#ed1e24"></i>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3  mb-5">
                        <!-- <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="background-color: #ff750a;  background: url(assets/media/patterns/vector-1.png) #ff750a no-repeat bottom right; box-shadow:0px 8px 0px 0px rgb(205 90 1)"> -->

                        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="box-shadow: rgba(0, 0, 0, 0.45) 0px 15px 20px -20px; border-bottom:5px solid #cb348f">

                            <div class="card-header pt-5 pb-5" style="min-height: 130px;">
                                <div class="card-title d-flex flex-column">
                                    <span class="fs-2hx fw-bold me-2 lh-1 ls-n2"> {{ $today_coaching_revenue }}</span>
                                    <span class="opacity-75 pt-4 fw-semibold fs-4">
                                     Coaching Revenue
                                    </span>
                                </div>
                                <div class="d-flex flex-center rounded-circle h-60px w-60px"
                                    style="border: 1px dashed #cb348f">
                                    <i class="fonticon-star fs-2x lh-0" style="color:#cb348f"></i>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3  mb-5">
                        <!-- <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="background-color: #2f2e89; background: url(assets/media/patterns/vector-1.png) #2f2e89 no-repeat bottom right; box-shadow:0px 8px 0px 0px rgb(33 32 94)"> -->

                        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end"
                            style="box-shadow: rgba(0, 0, 0, 0.45) 0px 15px 20px -20px; border-bottom:5px solid #2e8a48">

                            <div class="card-header pt-5 pb-5" style="min-height: 130px;">
                                <div class="card-title d-flex flex-column">
                                    <span class="fs-2hx fw-bold me-2 lh-1 ls-n2">{{ $today_complaint_count }}</span>
                                    <span class="opacity-75 pt-4 fw-semibold fs-4">No of Complaint</span>
                                </div>
                                <div class="d-flex flex-center rounded-circle h-60px w-60px"
                                    style="border: 1px dashed #2e8a48">
                                    <i class="fonticon-pin fs-2x lh-0" style="color:#2e8a48"></i>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <!--begin::Content-->


            <!--begin::Row-->
            <div class="row col-lg-12">
                <div class="col-lg-9 col-xl-9 col-xxl-9 mb-5 mb-xl-0">
                    <!--begin::Chart widget 3-->
                    <div class="card card-flush overflow-hidden">

                        <div class="card-header py-5">

                            <h3 class="card-title align-items-start flex-column">
                                <span class="card-label fw-bold text-dark">Monthly Revenue</span>
                                <span class="text-gray-400 mt-1 fw-semibold fs-6">All Sports</span>
                            </h3>

                            <!--begin::Toolbar-->
                            <div class="card-toolbar">
                                <!--begin::Menu-->

                                <!--begin::Menu 2-->
                                <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg-light-primary fw-semibold w-200px"
                                    data-kt-menu="true">
                                    <!--begin::Menu item-->
                                    <div class="menu-item px-3">
                                        <div class="menu-content fs-6 text-dark fw-bold px-3 py-4">Quick Actions</div>
                                    </div>
                                    <!--end::Menu item-->
                                    <!--begin::Menu separator-->
                                    <div class="separator mb-3 opacity-75"></div>
                                    <!--end::Menu separator-->
                                    <!--begin::Menu item-->
                                    <div class="menu-item px-3">
                                        <a href="#" class="menu-link px-3">New Ticket</a>
                                    </div>
                                    <!--end::Menu item-->
                                    <!--begin::Menu item-->
                                    <div class="menu-item px-3">
                                        <a href="#" class="menu-link px-3">New Customer</a>
                                    </div>
                                    <!--end::Menu item-->
                                    <!--begin::Menu item-->
                                    <div class="menu-item px-3" data-kt-menu-trigger="hover"
                                        data-kt-menu-placement="right-start">
                                        <!--begin::Menu item-->
                                        <a href="#" class="menu-link px-3">
                                            <span class="menu-title">New Group</span>
                                            <span class="menu-arrow"></span>
                                        </a>
                                        <!--end::Menu item-->
                                        <!--begin::Menu sub-->
                                        <div class="menu-sub menu-sub-dropdown w-175px py-4">
                                            <!--begin::Menu item-->
                                            <div class="menu-item px-3">
                                                <a href="#" class="menu-link px-3">Admin Group</a>
                                            </div>
                                            <!--end::Menu item-->
                                            <!--begin::Menu item-->
                                            <div class="menu-item px-3">
                                                <a href="#" class="menu-link px-3">Staff Group</a>
                                            </div>
                                            <!--end::Menu item-->
                                            <!--begin::Menu item-->
                                            <div class="menu-item px-3">
                                                <a href="#" class="menu-link px-3">Member Group</a>
                                            </div>
                                            <!--end::Menu item-->
                                        </div>
                                        <!--end::Menu sub-->
                                    </div>
                                    <!--end::Menu item-->
                                    <!--begin::Menu item-->
                                    <div class="menu-item px-3">
                                        <a href="#" class="menu-link px-3">New Contact</a>
                                    </div>
                                    <!--end::Menu item-->
                                    <!--begin::Menu separator-->
                                    <div class="separator mt-3 opacity-75"></div>
                                    <!--end::Menu separator-->
                                    <!--begin::Menu item-->
                                    <div class="menu-item px-3">
                                        <div class="menu-content px-3 py-3">
                                            <a class="btn btn-primary btn-sm px-4" href="#">Generate Reports</a>
                                        </div>
                                    </div>
                                    <!--end::Menu item-->
                                </div>
                                <!--end::Menu 2-->
                                <!--end::Menu-->
                            </div>
                            <!--end::Toolbar-->
                        </div>
                        <!--end::Header-->

                        <div class="card-body d-flex justify-content-between flex-column pb-1 px-0">
                            <!--begin::Statistics-->
                            <div class="px-9 mb-5">
                                <!--begin::Statistics-->
                                <div class="d-flex mb-2">
                                    <span class="fs-4 fw-semibold text-gray-400 me-1">₹</span>
                                    <span class="fs-2hx fw-bold text-gray-800 me-2 lh-1 ls-n2">
                                        {{ $current_month_revenue }}</span>
                                </div>
                                <!--end::Statistics-->
                                <!--begin::Description-->
                                <span class="fs-6 fw-semibold text-gray-400">Past Month ₹ {{ $past_month_revenue }}
                                </span>
                                <!--end::Description-->
                            </div>
                            <!--end::Statistics-->
                            <!--begin::Chart-->
                            <div id="kt_charts_widget_3" class="min-h-auto ps-4 pe-6" style="height: 250px"></div>
                            <!--end::Chart-->
                        </div>

                    </div>
                    <!--end::Chart widget 3-->
                </div>
                <div class="col-lg-3">
                    <div class="col-xxl-12 mb-md-5 mb-xl-10">
                        <div class="row g-5">
                            <div class="col-md-12 col-xl-12">
                                <div class="card card-flush">
                                    <div class="card-header pt-5">
                                        <div class="card-title d-flex flex-column">
                                            <span
                                                class="fs-2hx fw-bold text-dark me-2 lh-1 ls-n2">{{ $cus_count / 1000 }}k</span>
                                            <span class="text-gray-400 pt-1 fw-semibold fs-6">Total Customers</span>
                                        </div>
                                    </div>

                                    <div class="card-body d-flex flex-column justify-content-end pe-0 mb-5">
                                        <span class="fs-6 fw-bolder text-gray-800 d-block mb-2">Latest Customers</span>
                                        <div class="symbol-group symbol-hover flex-nowrap">
                                            @foreach ($last_5_cus as $_data)
                                                <div class="symbol symbol-35px symbol-circle" data-bs-toggle="tooltip"
                                                    title="Alan Warden">

                                                    <img alt="Pic" src=" {{ asset($_data->photo) }}" width="10px"
                                                        height="auto">


                                                </div>
                                            @endforeach
                                            <a href="#" class="symbol symbol-35px symbol-circle"
                                                data-bs-toggle="modal" data-bs-target="#kt_modal_view_users">
                                                <span
                                                    class="symbol-label bg-light text-gray-400 fs-8 fw-bold">+{{ $cus_count - 5 }}</span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12 col-xl-12">
                                <div class="card card-flush mb-xl-10">
                                    <div class="card-header pt-5">
                                        <div class="card-title d-flex flex-column">
                                            <div class="d-flex align-items-center">
                                                <span
                                                    class="fs-2hx fw-bold text-dark me-2 lh-1 ls-n2">{{ $total_booking_revenue }}</span>

                                            </div>
                                            <span class="text-gray-400 pt-1 fw-semibold fs-6">Total Sales</span>
                                        </div>
                                    </div>


                                    <div class="card-body d-flex align-items-end mb-5">
                                        <div class="d-flex align-items-center flex-column mt-3 w-100">
                                            <div class="d-flex justify-content-between w-100 mt-auto mb-2">
                                                <span
                                                    class="fw-bolder fs-6 text-dark">{{ getSetting('roi') - $total_booking_revenue }}
                                                    to Goal</span>
                                                <span
                                                    class="fw-bold fs-6 text-gray-400">{{ round(($total_booking_revenue / getSetting('roi')) * 100) }}%</span>
                                            </div>
                                            <div class="h-8px mx-3 w-100 bg-light-success rounded">
                                                <div class="bg-success rounded h-8px" role="progressbar"
                                                    style="width: {{ ($total_booking_revenue / getSetting('roi')) * 100 }}%;"
                                                    aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



            </div>

            <div class="row col-lg-12 mb-xl-10">
                <div class="col-xxl-12">
                    <div class="card card-flush">
                        <div class="card-header py-7 mb-3">
                            <h3 class="card-title align-items-start flex-column">
                                <span class="card-label fw-bold text-gray-800">Top Booking Sports</span>
                            </h3>
                        </div>

                        <div class="card-body py-0 ps-6 mt-n12">
                            <div id="kt_charts_widget_6"></div>
                        </div>
                    </div>
                </div>
            </div>




            <div class="row mb-5 mb-xl-10">

                <div class="row mb-5 mb-xl-10">

                  
                    <div class="col-xxl-12 col-xl-12">
                        <div class="card card-flush">

                            <div class="card-header">

                                <div class="card-title flex-column">
                                    <h3 class="fw-bold mb-1">Today Booking</h3>
                                </div>
                            </div>

                            <div class="card-body pt-0">
                                <div class="table-responsive">

                                    <table id="kt_profile_overview_table"
                                        class="table table-row-bordered table-row-dashed gs-3 align-middle fw-bold">

                                        <thead class="fs-7 text-gray-400 text-uppercase">
                                            <tr>
                                                <th class="min-w-90px">Name</th>
                                                <th class="min-w-90px">Date</th>
                                                <th class="min-w-150px">Sports</th>
                                                <th class="min-w-150px">Court</th>
                                                <th class="min-w-150px">Slots</th>
                                                <th class="min-w-150px">Status</th>
                                              
                                            </tr>
                                        </thead>
                                        <tbody class="fs-6">
                                            @foreach($latest_book as $_data)
                                            <tr>

                                                <td>{{$_data->Player->name}}</td>
                                                <td>{{$_data->date}}</td>
                                                <td>
                                                   {{$_data->sports}}
                                                </td>
                                                <td>
                                                   {{$_data->court}}
                                                </td>
                                                <td>
                                                    @foreach($_data->timings as $_data1)

                                                    {{ $_data1['start_time']."-".$_data1['end_time']; }}<br>

                                                    @endforeach
                                                  
                                                </td>
                                                <td>
                                                   {{$_data->booking_status}}
                                                </td>
                                                
                                                

                                                
                                            </tr>
                                            @endforeach

                                        </tbody>

                                    </table>

                                </div>

                            </div>
                        </div>

                    </div>

                </div>
            </div>





        </div>

    </div>
@endsection

@push('scripts')
    <!--end::Global Javascript Bundle-->
    <!--begin::Vendors Javascript(used by this page)-->
    <script src="{{ asset('admin/assets/plugins/custom/fullcalendar/fullcalendar.bundle.js') }}"></script>
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/percent.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/radar.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/map.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/geodata/worldLow.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/geodata/continentsLow.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/geodata/usaLow.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/geodata/worldTimeZonesLow.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/geodata/worldTimeZoneAreasLow.js"></script>
    <script src="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
    <!--end::Vendors Javascript-->
    <!--begin::Custom Javascript(used by this page)-->
    <script src="{{ asset('admin/assets/js/widgets.bundle.js') }}"></script>
    <script src="{{ asset('admin/assets/js/custom/widgets.js') }}"></script>
    <script src="{{ asset('admin/assets/js/custom/apps/chat/chat.js') }}"></script>
    <script src="{{ asset('admin/assets/js/custom/utilities/modals/upgrade-plan.js') }}"></script>
    <script src="{{ asset('admin/assets/js/custom/utilities/modals/create-app.js') }}"></script>
    <script src="{{ asset('admin/assets/js/custom/utilities/modals/new-target.js') }}"></script>
    <script src="{{ asset('admin/assets/js/custom/utilities/modals/users-search.js') }}"></script>


    <script>
        var KTChartsWidget3 = function() {
            var e = {
                    self: null,
                    rendered: !1
                },
                t = function(e) {
                    var t = document.getElementById("kt_charts_widget_3");
                    if (t) {
                        var a = parseInt(KTUtil.css(t, "height")),
                            l = KTUtil.getCssVariableValue("--kt-gray-500"),
                            r = KTUtil.getCssVariableValue("--kt-border-dashed-color"),
                            o = KTUtil.getCssVariableValue("--kt-success"),
                            i = {
                                series: [{
                                    name: "Sales",
                                    data: {!! json_encode($graph['month_data']) !!}
                                }],
                                chart: {
                                    fontFamily: "inherit",
                                    type: "area",
                                    height: a,
                                    toolbar: {
                                        show: !1
                                    }
                                },
                                plotOptions: {},
                                legend: {
                                    show: !1
                                },
                                dataLabels: {
                                    enabled: !1
                                },
                                fill: {
                                    type: "gradient",
                                    gradient: {
                                        shadeIntensity: 1,
                                        opacityFrom: .4,
                                        opacityTo: 0,
                                        stops: [0, 1, 2]
                                    }
                                },
                                stroke: {
                                    curve: "smooth",
                                    show: !0,
                                    width: 2,
                                    colors: [o]
                                },
                                xaxis: {
                                    categories: {!! json_encode($graph['month']) !!},
                                    axisBorder: {
                                        show: !1
                                    },
                                    axisTicks: {
                                        show: !1
                                    },
                                    tickAmount: 12,
                                    labels: {
                                        rotate: 0,
                                        rotateAlways: !0,
                                        style: {
                                            colors: l,
                                            fontSize: "12px"
                                        }
                                    },
                                    crosshairs: {
                                        position: "front",
                                        stroke: {
                                            color: o,
                                            width: 1,
                                            dashArray: 3
                                        }
                                    },
                                    tooltip: {
                                        enabled: !0,
                                        formatter: void 0,
                                        offsetY: 0,
                                        style: {
                                            fontSize: "12px"
                                        }
                                    }
                                },
                                yaxis: {
                                    tickAmount: 4,
                                    max: {{ max($graph['month_data']) }},
                                    min: 0,
                                    labels: {
                                        style: {
                                            colors: l,
                                            fontSize: "12px"
                                        },
                                        formatter: function(e) {
                                            return "₹" + Math.round(e) + "K"
                                        }
                                    }
                                },
                                states: {
                                    normal: {
                                        filter: {
                                            type: "none",
                                            value: 0
                                        }
                                    },
                                    hover: {
                                        filter: {
                                            type: "none",
                                            value: 0
                                        }
                                    },
                                    active: {
                                        allowMultipleDataPointsSelection: !1,
                                        filter: {
                                            type: "none",
                                            value: 0
                                        }
                                    }
                                },
                                tooltip: {
                                    style: {
                                        fontSize: "12px"
                                    },
                                    y: {
                                        formatter: function(e) {
                                            return "₹" + e + "K"
                                        }
                                    }
                                },
                                colors: [KTUtil.getCssVariableValue("--kt-success")],
                                grid: {
                                    borderColor: r,
                                    strokeDashArray: 4,
                                    yaxis: {
                                        lines: {
                                            show: !0
                                        }
                                    }
                                },
                                markers: {
                                    strokeColor: o,
                                    strokeWidth: 3
                                }
                            };
                        e.self = new ApexCharts(t, i), setTimeout((function() {
                            e.self.render(), e.rendered = !0
                        }), 200)
                    }
                };
            return {
                init: function() {
                    t(e), KTThemeMode.on("kt.thememode.change", (function() {
                        e.rendered && e.self.destroy(), t(e)
                    }))
                }
            }
        }();
        "undefined" != typeof module && (module.exports = KTChartsWidget3), KTUtil.onDOMContentLoaded((function() {
            KTChartsWidget3.init()
        }));

        var KTCardsWidget4 = {
            init: function() {
                ! function() {
                    var e = document.getElementById("kt_card_widget_4_chart");
                    if (e) {
                        var t = {
                                size: e.getAttribute("data-kt-size") ? parseInt(e.getAttribute("data-kt-size")) :
                                    70,
                                lineWidth: e.getAttribute("data-kt-line") ? parseInt(e.getAttribute(
                                    "data-kt-line")) : 11,
                                rotate: e.getAttribute("data-kt-rotate") ? parseInt(e.getAttribute(
                                    "data-kt-rotate")) : 145
                            },
                            a = document.createElement("canvas"),
                            l = document.createElement("span");
                        "undefined" != typeof G_vmlCanvasManager && G_vmlCanvasManager.initElement(a);
                        var r = a.getContext("2d");
                        a.width = a.height = t.size, e.appendChild(l), e.appendChild(a), r.translate(t.size / 2, t
                            .size / 2), r.rotate((t.rotate / 180 - .5) * Math.PI);
                        var o = (t.size - t.lineWidth) / 2,
                            i = function(e, t, a) {
                                a = Math.min(Math.max(0, a || 1), 1), r.beginPath(), r.arc(0, 0, o, 0, 2 * Math.PI *
                                    a, !1), r.strokeStyle = e, r.lineCap = "round", r.lineWidth = t, r.stroke()
                            };
                        i("#E4E6EF", t.lineWidth, 1), i(KTUtil.getCssVariableValue("--kt-danger"), t.lineWidth,
                            100 / 150), i(KTUtil.getCssVariableValue("--kt-primary"), t.lineWidth, .4)
                    }
                }()
            }
        };
        "undefined" != typeof module && (module.exports = KTCardsWidget4), KTUtil.onDOMContentLoaded((function() {
            KTCardsWidget4.init()
        }));


        var KTCardsWidget6 = {
            init: function() {
                ! function() {
                    var e = document.getElementById("kt_card_widget_6_chart");

                    if (e) {
                        var t = parseInt(KTUtil.css(e, "height")),
                            a = KTUtil.getCssVariableValue("--kt-gray-500"),
                            l = KTUtil.getCssVariableValue("--kt-border-dashed-color"),
                            r = KTUtil.getCssVariableValue("--kt-primary"),
                            o = KTUtil.getCssVariableValue("--kt-gray-300"),
                            i = new ApexCharts(e, {
                                series: [{
                                    name: "Booking",
                                    data: [30, 60, 53, 45, 60, 75, 53]
                                }],
                                chart: {
                                    fontFamily: "inherit",
                                    type: "bar",
                                    height: t,
                                    toolbar: {
                                        show: !1
                                    },
                                    sparkline: {
                                        enabled: !0
                                    }
                                },
                                plotOptions: {
                                    bar: {
                                        horizontal: !1,
                                        columnWidth: ["55%"],
                                        borderRadius: 6
                                    }
                                },
                                legend: {
                                    show: !1
                                },
                                dataLabels: {
                                    enabled: !1
                                },
                                stroke: {
                                    show: !0,
                                    width: 9,
                                    colors: ["transparent"]
                                },
                                xaxis: {
                                    axisBorder: {
                                        show: !1
                                    },
                                    axisTicks: {
                                        show: !1,
                                        tickPlacement: "between"
                                    },
                                    labels: {
                                        show: !1,
                                        style: {
                                            colors: a,
                                            fontSize: "12px"
                                        }
                                    },
                                    crosshairs: {
                                        show: !1
                                    }
                                },
                                yaxis: {
                                    labels: {
                                        show: !1,
                                        style: {
                                            colors: a,
                                            fontSize: "12px"
                                        }
                                    }
                                },
                                fill: {
                                    type: "solid"
                                },
                                states: {
                                    normal: {
                                        filter: {
                                            type: "none",
                                            value: 0
                                        }
                                    },
                                    hover: {
                                        filter: {
                                            type: "none",
                                            value: 0
                                        }
                                    },
                                    active: {
                                        allowMultipleDataPointsSelection: !1,
                                        filter: {
                                            type: "none",
                                            value: 0
                                        }
                                    }
                                },
                                tooltip: {
                                    style: {
                                        fontSize: "12px"
                                    },
                                    x: {
                                        formatter: function(e) {
                                            return e + "i"
                                        }
                                    },
                                    y: {
                                        formatter: function(e) {
                                            return e + ""
                                        }
                                    }
                                },
                                colors: [r, o],
                                grid: {
                                    padding: {
                                        left: 10,
                                        right: 10
                                    },
                                    borderColor: l,
                                    strokeDashArray: 4,
                                    yaxis: {
                                        lines: {
                                            show: !0
                                        }
                                    }
                                }
                            });
                        setTimeout((function() {
                            i.render()
                        }), 300)
                    }
                }()
            }
        };
        "undefined" != typeof module && (module.exports = KTCardsWidget6), KTUtil.onDOMContentLoaded((function() {
            KTCardsWidget6.init()
        }));
        var KTChartsWidget6 = function() {
            var e = {
                    self: null,
                    rendered: !1
                },
                t = function(e) {
                    var t = document.getElementById("kt_charts_widget_6");
                    if (t) {
                        var a = KTUtil.getCssVariableValue("--kt-gray-800"),
                            l = KTUtil.getCssVariableValue("--kt-border-dashed-color"),
                            r = {
                                series: [{
                                    name: "Sales",
                                    data: {!! json_encode($sports_cat_price) !!}
                                }],
                                chart: {
                                    fontFamily: "inherit",
                                    type: "bar",
                                    height: 350,
                                    toolbar: {
                                        show: !1
                                    }
                                },
                                plotOptions: {
                                    bar: {
                                        borderRadius: 8,
                                        horizontal: !0,
                                        distributed: !0,
                                        barHeight: 50,
                                        dataLabels: {
                                            position: "bottom"
                                        }
                                    }
                                },
                                dataLabels: {
                                    enabled: !0,
                                    textAnchor: "start",
                                    offsetX: 0,
                                    formatter: function(e, t) {
                                        // e *= 1e3;
                                        // return wNumb({
                                        //     thousand: ","
                                        // }).to(e)
                                        return e;
                                    },
                                    style: {
                                        fontSize: "14px",
                                        fontWeight: "600",
                                        align: "left"
                                    }
                                },
                                legend: {
                                    show: !1
                                },
                                colors: ["#3E97FF", "#F1416C", "#50CD89", "#FFC700", "#7239EA"],
                                xaxis: {
                                    categories: {!! json_encode($sports_cat) !!},
                                    labels: {
                                        formatter: function(e) {
                                            return e / 1000 + "K"
                                        },
                                        style: {
                                            colors: [a],
                                            fontSize: "14px",
                                            fontWeight: "600",
                                            align: "left"
                                        }
                                    },
                                    axisBorder: {
                                        show: !1
                                    }
                                },
                                yaxis: {
                                    labels: {
                                        formatter: function(e, t) {
                                            return Number.isInteger(e) ? e + " - " + parseInt(100 * e / 18)
                                                .toString() + "%" : e
                                        },
                                        style: {
                                            colors: a,
                                            fontSize: "14px",
                                            fontWeight: "600"
                                        },
                                        offsetY: 2,
                                        align: "left"
                                    }
                                },
                                grid: {
                                    borderColor: l,
                                    xaxis: {
                                        lines: {
                                            show: !0
                                        }
                                    },
                                    yaxis: {
                                        lines: {
                                            show: !1
                                        }
                                    },
                                    strokeDashArray: 4
                                },
                                tooltip: {
                                    style: {
                                        fontSize: "12px"
                                    },
                                    y: {
                                        formatter: function(e) {
                                            return e / 1000 + "K"
                                        }
                                    }
                                }
                            };
                        e.self = new ApexCharts(t, r), setTimeout((function() {
                            e.self.render(), e.rendered = !0
                        }), 200)
                    }
                };
            return {
                init: function() {
                    t(e), KTThemeMode.on("kt.thememode.change", (function() {
                        e.rendered && e.self.destroy(), t(e)
                    }))
                }
            }
        }();
        "undefined" != typeof module && (module.exports = KTChartsWidget6), KTUtil.onDOMContentLoaded((function() {
            KTChartsWidget6.init()
        }));
    </script>
    <!--end::Custom Javascript-->
    <!--end::Javascript-->
@endpush
