
<!--begin:Form-->
 <form id="booking_edit_form" class="form" enctype="multipart/form-data" action="{{ route('admin.sports.store') }}"
     method="POST">
     <div class="mb-13 text-center">
         <h1 class="mb-3 add-label">Edit Booking</h1>
     </div>
     <div class="row">
         <div class="col">
             <div class="d-flex flex-column mb-8 fv-row">
                 <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                     <span class="required">Name</span>
                     <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                         title="Please select duration"></i>
                 </label>
                 {{ $booking->player->name }}

             </div>
         </div>
         <input type="hidden" name="id" value="{{$id}}">
         <div class="col">
             <div class="d-flex flex-column mb-8 fv-row">
                 <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                     <span class="required">Mobile No</span>
                     <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                         title="Please select duration"></i>
                 </label>
                 {{ $booking->player->mobile }}
                 <div id="append_div"></div>

             </div>
         </div>
     </div>
     <div class="row">
         <div class="col">
             <div class="d-flex flex-column mb-8 fv-row">
                 <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                     <span class="required">Sports</span>
                     <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                         title="Please enter sports"></i>
                 </label>
                 {{ $booking->sports }}

             </div>
         </div>
         <div class="col">

             <div class="d-flex flex-column mb-8 fv-row">
                 <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                     <span class="required">Courts</span>
                     <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                         title="Please Package Price"></i>
                 </label>
                 <div>
                     {{ $booking->court }}

                 </div>

             </div>


         </div>
     </div>
     <div class="row">
         <div class="col">
             <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                 <span class="required">Select Slots</span>
                 <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                     title="Please Package Price"></i>
             </label>
             @foreach ($booking->timings as $_data)
                 <a href="#" class="btn fw-bold btn-danger"
                     style="padding:5px 10px; margin-bottom: 5px;">{{ $_data['start_time'] }} -
                     {{ $_data['end_time'] }}</a>
             @endforeach
         </div>
     </div>

     <div class="row">
         <div class="col">
             <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                 <span class="required">Amount</span>
                 <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                     aria-label="Please Package Price" data-kt-initialized="1"></i>
             </label>
             <div class="row">
                 <div class="col">
                     <table id="membership_desc_table"
                         class="table table-row-bordered table-row-dashed gy-4 align-middle fw-bold table table-row-bordered align-middle gy-4 gs-9">
                         <thead class="border-bottom border-gray-200 fs-6 text-gray-600 fw-bold bg-light bg-opacity-75">
                             <tr>
                                 <th class="min-w-150px">Grand Total</th>
                                 <th class="min-w-150px">Discount</th>
                                 <th class="min-w-150px">Play Coin</th>
                                 <th class="min-w-150px">Total</th>

                             </tr>
                         </thead>

                         <tbody class="fs-6">
                             <tr>
                                 <td>
                                     {{ $booking->total_payload['g_total'] }}
                                 </td>
                                 <td>
                                     - {{ $booking->total_payload['discount'] }}
                                 </td>
                                 <td>
                                     - {{ $booking->total_payload['play_coin'] }}
                                 </td>
                                 <td>
                                     {{ $booking->price }}
                                 </td>



                             </tr>
                         </tbody>
                     </table>
                 </div>

             </div>

         </div>
     </div>

     <div class="row">
         <div class="col">
             <div class="d-flex flex-column mb-8 fv-row">
                 <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                     <span class="required">Payment Status</span>
                     <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                         title="Please select duration"></i>
                 </label>
                 <div>
                        <select class="form-select form-select-solid" data-control="select2"
                                            data-hide-search="true" data-placeholder="Select Booking status" name="payment_status">
                                            <option value="">Select</option>
                                            <option value="success" {{( $booking->payment_status == 'success') ? 'selected' : '' }}>Success</option>
                                            <option value="refund" {{( $booking->payment_status == 'refund') ? 'selected' : '' }}>Refund</option>
                                          
                        </select>
                                    </div>


             </div>
         </div>
         <div class="col">
             <div class="d-flex flex-column mb-8 fv-row">
                 <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                     <span class="required">Booking Status</span>
                     <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                         title="Please select duration"></i>
                 </label>
                 <div>
                        <select class="form-select form-select-solid" data-control="select2"
                                            data-hide-search="true" data-placeholder="Select Booking status" name="booking_status">
                                            <option value="">Select</option>
                                            <option value="confirmed" {{( $booking->booking_status == 'confirmed') ? 'selected' : '' }}>Confirmed</option>
                                            <option value="canceled" {{( $booking->booking_status == 'canceled') ? 'selected' : '' }}>Canceled</option>
                                            <option value="rejected" {{( $booking->booking_status == 'rejected') ? 'selected' : '' }}>Rejected</option>
                                            <option value="failed" {{( $booking->booking_status == 'failed') ? 'selected' : '' }}>failed</option>
                        </select>
                 </div>
                

             </div>
         </div>
     </div>
     <div id="dynamic_append">
        @if($booking->payment_status=='refund')
         <div class="row">
            <div class="col">
                <div class="d-flex flex-column mb-8 fv-row">
                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                    <span class="required">Refund Amount</span>
                    <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip" title="Please select duration"></i>
                </label>
                <div>
                    <input type="text" class="form-control form-control-solid" placeholder="Please enter refund amount" name="refund_amount" id="refund_amount" value="{{$booking->refund_remarks['amount']}}" autocomplete="off">
                </div>
                </div>
            </div>
            <div class="col">
                <div class="d-flex flex-column mb-8 fv-row">
                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                    <span class="required">Remarks</span>
                    <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip" title="Please select duration"></i>
                </label>
                <div>
                    <input type="text" class="form-control form-control-solid" placeholder="Remark of refund" name="refund_remarks" id="refund_remarks" value="{{$booking->refund_remarks['remarks']}}"  autocomplete="off">
                </div>
                </div>
            </div>
            </div>
        @endif

        </div>
   

     <div class="row">
         <div class="col"> @csrf()</div>
     </div>
     @if ($booking->team_payload)
         <div class="row">
             <div class="col">
                 <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                     <span class="required">Team</span>
                     <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                         aria-label="Please Package Price" data-kt-initialized="1"></i>
                 </label>
                 <div class="row">
                     <div class="col">
                         <table id="membership_desc_table"
                             class="table table-row-bordered table-row-dashed gy-4 align-middle fw-bold table table-row-bordered align-middle gy-4 gs-9">
                             <thead
                                 class="border-bottom border-gray-200 fs-6 text-gray-600 fw-bold bg-light bg-opacity-75">
                                 <tr>
                                     <th class="min-w-150px">Name</th>
                                     <th class="min-w-150px">Mobile</th>
                                 </tr>
                             </thead>

                             <tbody class="fs-6">
                                 <tr>
                                     <td>
                                         {{ $booking->team_payload[0]['name'] }}
                                     </td>
                                     <td>
                                         {{ $booking->team_payload[1]['cap_no'] }}
                                     </td>




                                 </tr>
                             </tbody>
                         </table>
                     </div>

                 </div>

             </div>
         </div>




         <div class="row">
             <div class="col"> @csrf()</div>
         </div>
     @endif
     <div class="row">

         <div class="col">
             <div class="text-center">
                 <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3">Cancel</button>
                 <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                     <span class="indicator-label">Submit</span>
                     <span class="indicator-progress">Please wait... <span
                             class="spinner-border spinner-border-sm align-middle ms-2"></span>
                     </span>
                 </button>
             </div>
         </div>
     </div>



 </form>
<script>


</script>


 <!--end:Form-->
