
@extends('layouts.admin.app')
@push('styles')
    <!--begin::Vendor Stylesheets(used by this page)-->
    <link href="{{ asset('admin/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <!--end::Vendor Stylesheets-->
@endpush
@section('title')
    <title>Bookings Reports</title>
@endsection
@section('content')
<div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">

<div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">

    <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">

        <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
            Bookings Reports</h1>

        <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">

            <li class="breadcrumb-item text-muted">
                <a href="#" class="text-muted text-hover-primary">Home</a>
            </li>


            <li class="breadcrumb-item">
                <span class="bullet bg-gray-400 w-5px h-2px"></span>
            </li>


            <li class="breadcrumb-item text-muted">List</li>

        </ul>

    </div>
    <div class="d-flex align-items-center gap-2 gap-lg-3">

        <a href="#" class="btn btn-sm btn-flex bg-body btn-color-gray-700 btn-active-color-primary fw-bold"
            data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
            <!--begin::Svg Icon | path: icons/duotune/general/gen031.svg-->
            <span class="svg-icon svg-icon-6 svg-icon-muted me-1">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M19.0759 3H4.72777C3.95892 3 3.47768 3.83148 3.86067 4.49814L8.56967 12.6949C9.17923 13.7559 9.5 14.9582 9.5 16.1819V19.5072C9.5 20.2189 10.2223 20.7028 10.8805 20.432L13.8805 19.1977C14.2553 19.0435 14.5 18.6783 14.5 18.273V13.8372C14.5 12.8089 14.8171 11.8056 15.408 10.964L19.8943 4.57465C20.3596 3.912 19.8856 3 19.0759 3Z"
                        fill="currentColor"></path>
                </svg>
            </span>
            Filter
        </a>

        <div class="menu menu-sub menu-sub-dropdown w-250px w-md-300px" data-kt-menu="true"
            id="kt_menu_62cfa327e05f8">

            <div class="px-7 py-5">
                <div class="fs-5 text-dark fw-bold">Filter Options</div>
            </div>

            <div class="separator border-gray-200"></div>

            <div class="px-7 py-5">
                <form id="reports-filter-form">
                    <div class="mb-10">
                        <label class="form-label fw-semibold">From Date:</label>
                        <div>
                            <input type="date" class="form-control form-control-solid"
                                placeholder="Please Select first date" name="book_from_date" id="book_from_date">
                        </div>
                    </div>
                    <div class="mb-10">
                        <label class="form-label fw-semibold">To Date:</label>
                        <div>
                            <input type="date" class="form-control form-control-solid"
                                placeholder="Please Select to date" name="book_to_date" id="book_to_date">
                        </div>
                    </div>
                    <div class="mb-10">
                        <label class="form-label fw-semibold">Sports:</label>

                        <div>
                            <select class="form-select form-select-solid" data-control="select2"
                                data-hide-search="true" data-placeholder="Please enter  booking Sports"
                                name="book_sport" id="book_sport">
                                <option value=""></option>
                                @foreach ($Sports as $_data)
                                    <option value="{{ $_data->id }}">{{ $_data->name }}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>
                    <div class="mb-10">
                        <label class="form-label fw-semibold">Courts:</label>
                        <div>
                            <select class="form-select form-select-solid" data-control="select2"
                                data-hide-search="true" data-placeholder="Please select booking court"
                                name="book_court" id="book_court">
                                <option value=""></option>
                            </select>
                        </div>
                    </div>


                    <div class="mb-10">
                        <label class="form-label fw-semibold">Booking Status:</label>
                        <div>
                            <select class="form-select form-select-solid" data-control="select2"
                                data-hide-search="true" data-placeholder="Select Sloats" name="book_status"
                                id="book_status">
                                <option value=""></option>
                                <option value="confirmed">Confirmed</option>
                                <option value="canceled">Canceled</option>
                                <option value="rejected">Rejected</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>



                    <div class="d-flex justify-content-end">
                        <button type="reset"
                            class="btn btn-sm btn-light btn-active-light-primary me-2 filter_reset"
                            data-kt-menu-dismiss="true">Reset</button>
                        <button type="submit" class="btn btn-sm btn-danger  me-2" id="cus_export">Export</button>
                        <button type="submit" class="btn btn-sm btn-primary"
                            data-kt-menu-dismiss="true">Apply</button>
                    </div>
                </form>
            </div>

        </div>


    </div>

</div>

</div>
  <div id="append_reports">
  </div>
@endsection

@push('scripts')
<script>
var book_indexs = '{{ route('admin.post-booking-reports') }}';

$(document).on('submit', "#reports-filter-form", function() {
  
  let booking_form = document.querySelector('#reports-filter-form');
   axios.post(book_indexs, new FormData(booking_form))
   .then(function(response) {
       response = response.data;
       $('#append_reports').empty().html(response);
       console.log(response);
    })
   .catch(function(error) {
       console.log(error)
      })
   .then(function() {
         
   });

   return false;

});

$(document).ready(function(){
    $('#reports-filter-form').submit();
})
</script>
@endpush
