
<div id="" class="app-content flex-column-fluid">

<div id="" class="app-container container-fluid">

    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">

        <div class="col-xl-12">
            <!--begin::Chart widget 18-->
            <div class="card card-flush h-xl-100">
                <!--begin::Header-->
                <div class="card-header pt-7">
                    <!--begin::Title-->
                    <h3 class="card-title align-items-start flex-column">
                        <span class="card-label fw-bold text-gray-800">Booking Count</span>

                    </h3>
                    <!--end::Title-->
                    <!--begin::Toolbar-->

                </div>
                <!--end::Header-->
                <!--begin::Body-->
                <div class="card-body d-flex align-items-end px-0 pt-3 pb-5">
                    <!--begin::Chart-->
                    <div id="kt_charts_widget_18_chart" class="h-325px w-100 min-h-auto ps-4 pe-6"></div>
                    <!--end::Chart-->
                </div>
                <!--end: Card Body-->
            </div>
            <!--end::Chart widget 18-->
        </div>

        <div class="col-xxl-12">
            <div class="card card-flush mt-2">

                <div class="card-header mt-5">

                    <div class="card-title flex-column">
                        <h3 class="fw-bold mb-1"> List</h3>
                    </div>
                </div>

                <div class="card-body pt-0">
                    <div class="table-responsive">

                        <table id="booking_table"
                            class="table table-row-bordered table-row-dashed gs-3 align-middle fw-bold">

                            <thead class="fs-7 text-gray-400 text-uppercase">
                                <tr>
                                    <th class="min-w-50px">Id</th>
                                    <th class="min-w-50px">Date</th>
                                    <th class="min-w-90px">Name</th>
                                    <th class="min-w-50px">Sports </th>
                                    <th class="min-w-50px">Courts</th>
                                    <th class="min-w-150px">Slots</th>
                                    <th class="min-w-50px">Status</th>
                                    <th class="min-w-50px">Action</th>
                                </tr>
                            </thead>
                            <tbody class="fs-6">


                            </tbody>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>


</div>
</div>

    <script>
        var book_index = '{{ route('admin.bookings.index') }}';
        var book_edit = '{{ route('admin.bookings.edit', ':id') }}';
        var book_delete = '{{ route('admin.bookings.destroy', ':id') }}';
        var book_store = '{{ route('admin.bookings.store') }}';
        var book_update = '{{ route('admin.bookings.update', ':id') }}';
        var get_courts = '{{ route('admin.get-courts', ':id') }}';
        var book_exports = '{{ route('admin.bookings-export') }}';
        var save_book_edit = '{{ route('admin.booking-edit') }}';
    </script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script src="{{ asset('admin/assets/js/custom/apps/booking/booking.js') }}"></script>
    <script src="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
    <script>
        "use strict";

        // Class definition
        var KTChartsWidget18 = function() {
            var chart = {
                self: null,
                rendered: false
            };

            // Private methods
            var initChart = function(chart) {
                var element = document.getElementById("kt_charts_widget_18_chart");

                if (!element) {
                    return;
                }

                var height = parseInt(KTUtil.css(element, 'height'));
                var labelColor = KTUtil.getCssVariableValue('--kt-gray-900');
                var borderColor = KTUtil.getCssVariableValue('--kt-border-dashed-color');

                var options = {
                    series: [{
                        name: 'Booking Count',
                        data: {!! json_encode(array_column($sports_count, 'booking_reports_count')) !!}
                    }],
                    chart: {
                        fontFamily: 'inherit',
                        type: 'bar',
                        height: height,
                        toolbar: {
                            show: false
                        }
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: ['8%'],
                            borderRadius: 1,
                            dataLabels: {
                                position: "top" // top, center, bottom
                            },
                            startingShape: 'flat'
                        },
                    },
                    legend: {
                        show: false
                    },
                    dataLabels: {
                        enabled: true,
                        offsetY: -28,
                        style: {
                            fontSize: '13px',
                            colors: [labelColor]
                        },
                        formatter: function(val) {
                            return val; // + "H";
                        }
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories: {!! json_encode(array_column($sports_count, 'name')) !!},
                        axisBorder: {
                            show: false,
                        },
                        axisTicks: {
                            show: false
                        },
                        labels: {
                            style: {
                                colors: KTUtil.getCssVariableValue('--kt-gray-500'),
                                fontSize: '13px'
                            }
                        },
                        crosshairs: {
                            fill: {
                                gradient: {
                                    opacityFrom: 0,
                                    opacityTo: 0
                                }
                            }
                        }
                    },
                    yaxis: {
                        labels: {
                            style: {
                                colors: KTUtil.getCssVariableValue('--kt-gray-500'),
                                fontSize: '13px'
                            },
                            formatter: function(val) {
                                return val.toFixed(1);
                            }
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    states: {
                        normal: {
                            filter: {
                                type: 'none',
                                value: 0
                            }
                        },
                        hover: {
                            filter: {
                                type: 'none',
                                value: 0
                            }
                        },
                        active: {
                            allowMultipleDataPointsSelection: false,
                            filter: {
                                type: 'none',
                                value: 0
                            }
                        }
                    },
                    tooltip: {
                        style: {
                            fontSize: '12px'
                        },
                        y: {
                            formatter: function(val) {
                                return +val + ' Persons'
                            }
                        }
                    },
                    colors: [KTUtil.getCssVariableValue('--kt-primary'), KTUtil.getCssVariableValue(
                        '--kt-primary-light')],
                    grid: {
                        borderColor: borderColor,
                        strokeDashArray: 4,
                        yaxis: {
                            lines: {
                                show: true
                            }
                        }
                    }
                };

                chart.self = new ApexCharts(element, options);

                // Set timeout to properly get the parent elements width
                setTimeout(function() {
                    chart.self.render();
                    chart.rendered = true;
                }, 200);
            }

            // Public methods
            return {
                init: function() {
                    initChart(chart);

                    // Update chart on theme mode change
                    KTThemeMode.on("kt.thememode.change", function() {
                        if (chart.rendered) {
                            chart.self.destroy();
                        }

                        initChart(chart);
                    });
                }
            }
        }();

        // Webpack support
        if (typeof module !== 'undefined') {
            module.exports = KTChartsWidget18;
        }

        // On document ready
        KTUtil.onDOMContentLoaded(function() {
            KTChartsWidget18.init();
        });



      
    </script>
