
@extends('layouts.admin.app')
@push('styles')
    <!--begin::Vendor Stylesheets(used by this page)-->
    <link href="{{ asset('admin/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <!--end::Vendor Stylesheets-->
@endpush

@section('title')

<title>Roles</title>

@endsection 
@section('content')
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">

        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">

            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">

                <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                    Users</h1>

                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">

                    <li class="breadcrumb-item text-muted">
                        <a href="#" class="text-muted text-hover-primary">Home</a>
                    </li>


                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-400 w-5px h-2px"></span>
                    </li>


                    <li class="breadcrumb-item text-muted">Roles</li>

                </ul>

            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">

                <a href="#" class="btn btn-sm fw-bold btn-primary" id="add_role">Add Role</a>

            </div>

        </div>

    </div>


    <div id="" class="app-content flex-column-fluid">

        <div id="" class="app-container container-fluid">

            <div class="row g-5 g-xl-10 mb-5 mb-xl-10">



                <div class="col-xxl-12">
                    <div class="card card-flush mt-2">

                        <div class="card-header mt-5">

                            <div class="card-title flex-column">
                                <h3 class="fw-bold mb-1"> List</h3>
                            </div>
                        </div>

                        <div class="card-body pt-0">
                            <div class="table-responsive">

                                <table id="roles_table"
                                    class="table table-row-bordered table-row-dashed gy-4 align-middle fw-bold">

                                    <thead class="fs-7 text-gray-400 text-uppercase">
                                        <tr>
                                            <th class="min-w-90px">Id</th>
                                            <th class="min-w-90px">Name</th>
                                            <th class="min-w-50px">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody class="fs-6">
                                      
                                    </tbody>

                                </table>

                            </div>

                        </div>

                    </div>

                </div>

            </div>


        </div>
    </div>
@endsection
@section('modal')
    <div class="modal fade" id="kt_modal_new_target" tabindex="-1" role="dialog">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                    transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                    fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->
                    <form id="role_form" class="form" enctype="multipart/form-data"
                        action="{{ route('admin.roles.store') }}" method="POST">
                        <div class="mb-13 text-center">
                            <h1 class="mb-3 add-label">Add Role</h1>
                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Name</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter role name"></i>
                            </label>
                            <input type="text" class="form-control form-control-solid" placeholder="Please Enter Role Name"
                                name="role_name" id="role_name" />
                       </div>
                       
                       <div class="row mb-6">
														
														<!--begin::Col-->
														<div class="col-lg-12 fv-row fv-plugins-icon-container fv-plugins-bootstrap5-row-invalid">
															<!--begin::Options-->
															<div class="d-flex align-items-center mt-3">

															<div class="form-group mb-5">
                                                                   <p  class="mb-5"><strong>Permission:</strong></p>
                                                                          <div style="width:100%; float:left">
                                                            @foreach($permission as $_data)
                                                            <label style="float:left; width:20%" class="form-check form-check-sm form-check-custom form-check-solid me-5 me-lg-10 mb-4">
															<input class="form-check-input me-2" name="permission[]" type="checkbox" value="{{$_data['id']}}">
														    {{$_data['name']}}  
															</label>
                                                            
                                                            @endforeach
                                                            </div>  </div>
                                                                
															</div>
															<!--end::Options-->
													<!--end::Col-->
</div>
                        <div id="append_div"></div>
                     
                        
                      
                    
													
                        @csrf()
                       
                        <div class="text-center">
                            <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3">Cancel</button>
                            <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                <span class="indicator-label">Submit</span>
                                <span class="indicator-progress">Please wait... <span
                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>
                        </div>
                    </form>


                    <!--end:Form-->
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
@endsection
@push('scripts')
    <script>
        var role_index = '{{ route('admin.roles.index') }}';
        var role_edit = '{{ route('admin.roles.edit', ':id') }}';
        var role_delete = '{{ route('admin.roles.destroy', ':id') }}';
        var role_store = '{{ route('admin.roles.store') }}';
        var role_update = '{{ route('admin.roles.update', ':id') }}';
    </script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script src="{{ asset('admin/assets/js/custom/apps/role/role.js') }}"></script>
    <script src="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
@endpush
