
@extends('layouts.admin.app')
@push('styles')
    <!--begin::Vendor Stylesheets(used by this page)-->
    <link href="{{ asset('admin/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <!--end::Vendor Stylesheets-->
@endpush

@section('title')
    <title>Playcoin</title>
@endsection
@section('content')
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">

        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">

            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">

                <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                    Playcoin</h1>

                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">

                    <li class="breadcrumb-item text-muted">
                        <a href="#" class="text-muted text-hover-primary">Home</a>
                    </li>


                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-400 w-5px h-2px"></span>
                    </li>


                    <li class="breadcrumb-item text-muted">Playcoin</li>

                </ul>

            </div>
            <!-- <div class="d-flex align-items-center gap-2 gap-lg-3">

                    <a href="#" class="btn btn-sm fw-bold btn-primary" id="add_sports">Add Players</a>

                </div> -->

        </div>

    </div>


    <div id="" class="app-content flex-column-fluid">

        <div id="" class="app-container container-fluid">

            <div class="row g-5 g-xl-10 mb-5 mb-xl-10">



                <div class="col-xxl-12">
                    <div class="card mb-5 mb-xl-10">


                        <div id="kt_account_settings_profile_details" class="collapse show">

                            <form id="kt_account_profile_details_form" class="form">

                                <div class="card-body border-top p-9">


                                    <div class="row mb-6">

                                        <label class="col-lg-4 col-form-label required fw-semibold fs-6"> Cashback Coins for a booking</label>


                                        <div class="col-lg-8">


                                            <input type="text" name="fname"
                                                class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                                                placeholder="" value="10%" />
                                        </div>


                                    </div>
                                    <div class="row mb-6">

                                        <label class="col-lg-4 col-form-label required fw-semibold fs-6">Maximun coin usage for a booking</label>


                                        <div class="col-lg-8">


                                            <input type="text" name="fname"
                                                class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                                                placeholder="" value="10" />
                                        </div>
                                    </div>
                                   
                                   


                                   

                                </div>
                                <!--end::Card body-->
                                <!--begin::Actions-->
                                <div class="card-footer d-flex justify-content-end py-6 px-9">
                                    <button type="reset"
                                        class="btn btn-light btn-active-light-primary me-2">Discard</button>
                                    <button type="submit" class="btn btn-primary"
                                        id="kt_account_profile_details_submit">Save Changes</button>
                                </div>
                                <!--end::Actions-->
                            </form>
                            <!--end::Form-->
                        </div>
                        <!--end::Content-->
                    </div>

                </div>


            </div>


        </div>
    </div>
@endsection
@section('modal')
    <div class="modal fade" id="kt_modal_new_target" tabindex="-1" role="dialog">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-650px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                    transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                    fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->
                    <form id="sports_form" class="form" enctype="multipart/form-data"
                        action="{{ route('admin.sports.store') }}" method="POST">
                        <div class="mb-13 text-center">
                            <h1 class="mb-3 add-label">Add Play</h1>
                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Package Name</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter sports"></i>
                            </label>
                            <input type="text" class="form-control form-control-solid"
                                placeholder="Please enter package name" name="sports_name" id="sports_name" />

                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Amount</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter sports"></i>
                            </label>
                            <input type="text" class="form-control form-control-solid" placeholder="Please enter amount"
                                name="sports_name" id="sports_name" />

                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Duration</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter sports"></i>
                            </label>
                            <select class="form-select form-select-solid" data-control="select2" data-hide-search="true"
                                data-placeholder="Select Duration" name="">
                                <option value="">Select</option>
                                <option value="1">3 Months</option>
                                <option value="2">6 Months</option>
                                <option value="3">9 Months</option>
                            </select>

                        </div>




                        @csrf()

                        <div class="text-center">
                            <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3">Cancel</button>
                            <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                <span class="indicator-label">Submit</span>
                                <span class="indicator-progress">Please wait... <span
                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>
                        </div>
                    </form>


                    <!--end:Form-->
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
@endsection
@push('scripts')
    <script>
        var spo_index = '{{ route('admin.sports.index') }}';
        var spo_edit = '{{ route('admin.sports.edit', ':id') }}';
        var spo_delete = '{{ route('admin.sports.destroy', ':id') }}';
        var spo_store = '{{ route('admin.sports.store') }}';
        var spo_update = '{{ route('admin.sports.update', ':id') }}';
    </script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script src="{{ asset('admin/assets/js/custom/apps/product/product.js') }}"></script>
    <script src="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
@endpush
