
@extends('layouts.admin.app')
@push('styles')
    <!--begin::Vendor Stylesheets(used by this page)-->
    <link href="{{ asset('admin/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <!--end::Vendor Stylesheets-->
@endpush

@section('title')
    <title>Setting</title>
@endsection
@section('content')
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">

        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">

            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">

                <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                    Setting</h1>

                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">

                    <li class="breadcrumb-item text-muted">
                        <a href="#" class="text-muted text-hover-primary">Home</a>
                    </li>


                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-400 w-5px h-2px"></span>
                    </li>


                    <li class="breadcrumb-item text-muted">Site Setting</li>

                </ul>

            </div>
            <!-- <div class="d-flex align-items-center gap-2 gap-lg-3">

                    <a href="#" class="btn btn-sm fw-bold btn-primary" id="add_sports">Add Players</a>

                </div> -->

        </div>

    </div>


    <div id="" class="app-content flex-column-fluid">

        <div id="" class="app-container container-fluid">

            <div class="row g-5 g-xl-10 mb-5 mb-xl-10">



                <div class="col-xxl-12">
                    <div class="card mb-5 mb-xl-10">

                        <div id="kt_account_settings_profile_details" class="collapse show">

                            <form id="kt_account_profile_details_form" class="form">

                                <div class="card-body border-top p-9">

                                    <div class="row">
                                        <div class="col">
                                            <div class="d-flex flex-column mb-8 fv-row">
                                                <label class="form-label fw-semibold">Playcoin Cachback - Normal user</label>
                                                <div>
                                                    <input type="text" class="form-control form-control-solid"
                                                        placeholder="Playcoin Cachback" name="playcoin_cashback_nuser"
                                                        id="playcoin_cashback_nuser" value="{{(getSetting('playcoin_cashback_nor_user'))  ? getSetting('playcoin_cashback_nor_user') : '0' }}"/>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="d-flex flex-column mb-8 fv-row">
                                                <label class="form-label fw-semibold">Playcoin Cachback - Membership</label>
                                                <div>
                                                    <input type="text" class="form-control form-control-solid"
                                                        placeholder="Playcoin Cachback - Membership User" name="playcoin_cashback_muser"
                                                        id="playcoin_cashback_muser" value="{{(getSetting('playcoin_cashback_mem_user'))  ? getSetting('playcoin_cashback_mem_user') : '0' }}"/>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="d-flex flex-column mb-8 fv-row">
                                                <label class="form-label fw-semibold">Playcoin Max Use for booking</label>
                                                <div>
                                                    <input type="text" class="form-control form-control-solid"
                                                        placeholder="Membership Price per slot" name="play_coin_max_use"
                                                        id="play_coin_max_use" value="{{(getSetting('playcoin_max_usage'))  ? getSetting('playcoin_max_usage') : '0' }}" />

                                                </div>

                                            </div>
                                        </div>
                                       
                                    </div>

                                    <div class="row">
                                        <div class="col">
                                            <div class="d-flex flex-column mb-8 fv-row">
                                                <label class="form-label fw-semibold">Referal Sender Get Coin</label>
                                                <div>
                                                    <input type="text" class="form-control form-control-solid"
                                                        placeholder="Referal Sender Get Coin" name="referal_sender_gain"
                                                        id="referal_sender_gain" value="{{(getSetting('referal_sender'))  ? getSetting('referal_sender') : '0' }}"/>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="d-flex flex-column mb-8 fv-row">
                                                <label class="form-label fw-semibold">Referal Receiver Get Coin</label>
                                                <div>
                                                    <input type="text" class="form-control form-control-solid"
                                                        placeholder="Referal Sender Get Coin" name="referal_receiver_gain"
                                                        id="referal_receiver_gain" value="{{(getSetting('referal_receiver'))  ? getSetting('referal_receiver') : '0' }}"/>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="d-flex flex-column mb-8 fv-row">
                                                <label class="form-label fw-semibold">Referal Link</label>
                                                <div>
                                                    <input type="text" class="form-control form-control-solid"
                                                        placeholder="Membership Price per slot" name="referal_link"
                                                        id="referal_link" value="{{(getSetting('referal_link'))  ? getSetting('referal_link') : '0' }}"/>

                                                </div>

                                            </div>
                                        </div>
                                       
                                    </div>

                                    <div class="row">
                                        <div class="col">
                                            <div class="d-flex flex-column mb-8 fv-row">
                                                <label class="form-label fw-semibold">Refund Percentage</label>
                                                <div>
                                                    <input type="text" class="form-control form-control-solid"
                                                        placeholder="Refund Percentage" name="refund_percentage"
                                                        id="refund_percentage" value="{{(getSetting('refund_per'))  ? getSetting('refund_per') : '0' }}"/>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="d-flex flex-column mb-8 fv-row">
                                                <label class="form-label fw-semibold">Cancel Approve Max hour</label>
                                                <div>
                                                    <input type="text" class="form-control form-control-solid"
                                                        placeholder="Referal Sender Get Coin" name="cancel_approve_max_hour"
                                                        id="cancel_approve_max_hour" value="{{(getSetting('canceL_approve_max_hour'))  ? getSetting('canceL_approve_max_hour') : '0' }}"/>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="d-flex flex-column mb-8 fv-row">
                                                <label class="form-label fw-semibold">ROI</label>
                                                <div>
                                                    <input type="text" class="form-control form-control-solid"
                                                        placeholder="Referal Sender Get Coin" name="roi"
                                                        id="roi" value="{{(getSetting('roi'))  ? getSetting('roi') : '0' }}"/>
                                                </div>

                                            </div>
                                        </div>
                                       
                                    </div>


                                </div>
                                <!--end::Card body-->
                                <!--begin::Actions-->
                                <div class="card-footer d-flex justify-content-end py-6 px-9">
                                    <button type="reset"
                                        class="btn btn-light btn-active-light-primary me-2">Discard</button>
                                    <button type="submit" class="btn btn-primary"
                                        id="kt_account_setting_submit">Save Changes</button>
                                </div>
                                <!--end::Actions-->
                            </form>
                            <!--end::Form-->
                        </div>
                        <!--end::Content-->
                    </div>

                </div>


            </div>


        </div>
    </div>
@endsection
@section('modal')
    <div class="modal fade" id="kt_modal_new_target" tabindex="-1" role="dialog">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-650px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2"
                                    rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->
                    <form id="sports_form" class="form" enctype="multipart/form-data"
                        action="{{ route('admin.sports.store') }}" method="POST">
                        <div class="mb-13 text-center">
                            <h1 class="mb-3 add-label">Add Play</h1>
                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Package Name</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter sports"></i>
                            </label>
                            <input type="text" class="form-control form-control-solid"
                                placeholder="Please enter package name" name="sports_name" id="sports_name" />

                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Amount</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter sports"></i>
                            </label>
                            <input type="text" class="form-control form-control-solid"
                                placeholder="Please enter amount" name="sports_name" id="sports_name" />

                        </div>
                        <div class="d-flex flex-column mb-8 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                <span class="required">Duration</span>
                                <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                    title="Please enter sports"></i>
                            </label>
                            <select class="form-select form-select-solid" data-control="select2" data-hide-search="true"
                                data-placeholder="Select Duration" name="">
                                <option value="">Select</option>
                                <option value="1">3 Months</option>
                                <option value="2">6 Months</option>
                                <option value="3">9 Months</option>
                            </select>

                        </div>




                        @csrf()

                        <div class="text-center">
                            <button type="reset" id="kt_modal_new_target_cancel"
                                class="btn btn-light me-3">Cancel</button>
                            <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                <span class="indicator-label">Submit</span>
                                <span class="indicator-progress">Please wait... <span
                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>
                        </div>
                    </form>


                    <!--end:Form-->
                </div>
                <!--end::Modal body-->
            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
    </div>
@endsection
@push('scripts')
    <script>
        var setting_index = '{{ route('admin.setting.index') }}';
        var setting_edit = '{{ route('admin.setting.edit', ':id') }}';
        var setting_delete = '{{ route('admin.setting.destroy', ':id') }}';
        var setting_store = '{{ route('admin.setting.store') }}';
        var setting_update = '{{ route('admin.setting.update', ':id') }}';
    </script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script src="{{ asset('admin/assets/js/custom/apps/setting/setting.js') }}"></script>
   
@endpush
