
@extends('layouts.admin.app')
@push('styles')
    <!--begin::Vendor Stylesheets(used by this page)-->
    <link href="{{ asset('admin/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <!--end::Vendor Stylesheets-->
@endpush

@section('title')
    <title>Tournament</title>
@endsection
@section('content')
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">

        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">

            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">

                <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                    Tournament</h1>

                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">

                    <li class="breadcrumb-item text-muted">
                        <a href="#" class="text-muted text-hover-primary">Home</a>
                    </li>


                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-400 w-5px h-2px"></span>
                    </li>


                    <li class="breadcrumb-item text-muted">Plans</li>

                </ul>

            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">

                <a href="#" class="btn btn-sm fw-bold btn-primary" id="add_sports">Add Tournament</a>

            </div>

        </div>

    </div>


    <div id="" class="app-content flex-column-fluid">

        <div id="" class="app-container container-fluid">

            <div class="row g-5 g-xl-10 mb-5 mb-xl-10">



                <div class="col-xxl-12">
                    <div class="card card-flush mt-2">

                        <div class="card-header mt-5">

                            <div class="card-title flex-column">
                                <h3 class="fw-bold mb-1"> List</h3>
                            </div>
                        </div>

                        <div class="card-body pt-0">
                            <div class="table-responsive">

                                <table id="tournament_table"
                                    class="table table-row-bordered table-row-dashed gy-4 align-middle fw-bold">

                                    <thead class="fs-7 text-gray-400 text-uppercase">
                                        <tr>
                                            <th class="min-w-90px">Id</th>
                                            <th class="min-w-90px">Date</th>
                                            <th class="min-w-90px">Time</th>
                                            <th class="min-w-90px">Name</th>
                                            <th class="min-w-90px">Status</th>
                                            <th class="min-w-50px">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="fs-6">

                                    </tbody>

                                </table>

                            </div>

                        </div>

                    </div>

                </div>

            </div>


        </div>
    </div>
@endsection
@section('modal')
    <div class="modal fade" id="kt_modal_new_target" tabindex="-1" role="dialog">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-1000px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2"
                                    rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->
                    <form id="membership_form" class="form" enctype="multipart/form-data"
                        action="{{ route('admin.sports.store') }}" method="POST">
                        <div class="mb-13 text-center">
                            <h1 class="mb-3 add-label">Add Touranament</h1>
                        </div>
                        <div class="row">
                            <div class="col">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Name</span>
                                        <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                            title="Please select duration"></i>
                                    </label>
                                    <input type="text" class="form-control form-control-solid"
                                        placeholder="Please enter touranament" name="touranament_name"
                                        id="touranament_name" />

                                </div>
                            </div>
                            <div class="col image_append">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <label class="form-label fw-semibold">Image</label>
                                    <div>
                                        <div class="image-input image-input-outline" data-kt-image-input="true"
                                            style="background-image: url({{ asset('admin/assets/media/avatars/blank.svg') }})">

                                            <div class="image-input-wrapper w-125px h-125px tournament_img1"
                                                style="background-image: url({{ asset('admin/assets/media/avatars/upload.png') }})">
                                            </div>

                                            <label
                                                class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                                data-kt-image-input-action="change" data-bs-toggle="tooltip"
                                                title="Change avatar">
                                                <i class="bi bi-pencil-fill fs-7"></i>
                                                <input type="file" name="file[]" accept=".png, .jpg, .jpeg" />
                                                <input type="hidden" name="avatar_remove" />

                                            </label>


                                            <span
                                                class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                                data-kt-image-input-action="cancel" data-bs-toggle="tooltip"
                                                title="Cancel avatar">
                                                <i class="bi bi-x fs-2"></i>
                                            </span>
                                            <span
                                                class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                                data-kt-image-input-action="remove" data-bs-toggle="tooltip"
                                                title="Remove avatar">
                                                <i class="bi bi-x fs-2"></i>
                                            </span>

                                        </div>
                                        <div class="form-text">Allowed file types: png, jpg, jpeg.</div>
                                    </div>
                                    <div>
                                        <div class="image-input image-input-outline" data-kt-image-input="true"
                                            style="background-image: url({{ asset('admin/assets/media/avatars/blank.svg') }})">

                                            <div class="image-input-wrapper w-125px h-125px tournament_img2"
                                                style="background-image: url({{ asset('admin/assets/media/avatars/upload.png') }})">
                                            </div>

                                            <label
                                                class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                                data-kt-image-input-action="change" data-bs-toggle="tooltip"
                                                title="Change avatar">
                                                <i class="bi bi-pencil-fill fs-7"></i>
                                                <input type="file" name="file[]" accept=".png, .jpg, .jpeg" />
                                                <input type="hidden" name="avatar_remove" />

                                            </label>


                                            <span
                                                class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                                data-kt-image-input-action="cancel" data-bs-toggle="tooltip"
                                                title="Cancel avatar">
                                                <i class="bi bi-x fs-2"></i>
                                            </span>
                                            <span
                                                class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                                data-kt-image-input-action="remove" data-bs-toggle="tooltip"
                                                title="Remove avatar">
                                                <i class="bi bi-x fs-2"></i>
                                            </span>

                                        </div>
                                        <div class="form-text">Allowed file types: png, jpg, jpeg.</div>
                                    </div>
                                    <div>
                                        <div class="image-input image-input-outline" data-kt-image-input="true"
                                            style="background-image: url({{ asset('admin/assets/media/avatars/blank.svg') }})">

                                            <div class="image-input-wrapper w-125px h-125px tournament_img3"
                                                style="background-image: url({{ asset('admin/assets/media/avatars/upload.png') }})">
                                            </div>

                                            <label
                                                class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                                data-kt-image-input-action="change" data-bs-toggle="tooltip"
                                                title="Change avatar">
                                                <i class="bi bi-pencil-fill fs-7"></i>
                                                <input type="file" name="file[]" accept=".png, .jpg, .jpeg" />
                                                <input type="hidden" name="avatar_remove" />

                                            </label>


                                            <span
                                                class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                                data-kt-image-input-action="cancel" data-bs-toggle="tooltip"
                                                title="Cancel avatar">
                                                <i class="bi bi-x fs-2"></i>
                                            </span>
                                            <span
                                                class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow"
                                                data-kt-image-input-action="remove" data-bs-toggle="tooltip"
                                                title="Remove avatar">
                                                <i class="bi bi-x fs-2"></i>
                                            </span>

                                        </div>
                                        <div class="form-text">Allowed file types: png, jpg, jpeg.</div>
                                    </div>
                                </div>
                               
                            </div>

                        </div><div id="append_div"></div>
                        <div class="row">
                            <div class="col">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Date</span>
                                        <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                            title="Please enter sports"></i>
                                    </label>
                                    <input type="date" class="form-control form-control-solid"
                                        placeholder="Please enter date" name="touranament_date" id="touranament_date" />

                                </div>
                            </div>
                            <div class="col">

                                <div class="d-flex flex-column mb-8 fv-row">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Time</span>
                                        <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                            title="Please Package Price"></i>
                                    </label>
                                    <div>
                                        <input type="time" class="form-control form-control-solid"
                                            name="touranament_time" id="touranament_time">

                                    </div>

                                </div>


                            </div>
                            <div class="col">

                                <div class="d-flex flex-column mb-8 fv-row">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Status</span>
                                        <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                            title="Please Package Price"></i>
                                    </label>
                                    <div>
                                        <select class="form-select form-select-solid" data-control="select2"
                                            data-hide-search="true" data-placeholder="Select Rolad" name="touranament_status" id="touranament_status">
                                            <option value="1">Active</option>
                                            <option value="0">DeActive</option>


                                        </select>

                                    </div>

                                </div>


                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                    <span class="required">Description</span>
                                    <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                        title="Please Package Price"></i>
                                </label>
                                <textarea name="touranament_desc" id="summernote"></textarea>

                            </div>
                        </div>
                      
                </div>

                <div class="row">
                    <div class="col"> @csrf()</div>
                </div>
                <div class="row">

                    <div class="col">
                        <div class="text-center">
                            <button type="reset" id="kt_modal_new_target_cancel"
                                class="btn btn-light me-3">Cancel</button>
                            <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                <span class="indicator-label">Submit</span>
                                <span class="indicator-progress">Please wait... <span
                                        class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>
                        </div>
                    </div>
                </div>

                </form>


                <!--end:Form-->
            </div>
            <!--end::Modal body-->

        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->

    </div>
@endsection
@push('scripts')
    <script>
        var touranament_index = '{{ route('admin.touranament.index') }}';
        var touranament_edit = '{{ route('admin.touranament.edit', ':id') }}';
        var touranament_delete = '{{ route('admin.touranament.destroy', ':id') }}';
        var touranament_store = '{{ route('admin.touranament.store') }}';
        var touranament_update = '{{ route('admin.touranament.update', ':id') }}';
    </script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script src="{{ asset('admin/assets/js/custom/apps/tournament/tournament.js') }}"></script>
    <script src="{{ asset('admin/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
    <script src="{{ asset('admin/assets/js/custom/apps/ecommerce/catalog\save-product.js') }}"></script>
    <!-- include summernote css/js -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#summernote').summernote({
                placeholder: 'Enter Description',
                tabsize: 2,
                height: 500
            });
        });
    </script>
@endpush
