<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\RegisterController;
use App\Http\Controllers\Api\BookingController;
use App\Http\Controllers\Api\CouchingController;
use App\Http\Controllers\Api\UserProfileController;
use App\Http\Controllers\Api\SportsController;
use App\Http\Controllers\Api\MembershipPackageController;
use App\Http\Controllers\Api\ReviewController;
use App\Http\Controllers\Api\ComplaintController;
use App\Http\Controllers\Api\TournamentContoller;
use App\Http\Controllers\Api\SettingController;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\NotificationController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::controller(RegisterController::class)->group(function () {
    Route::post('signup', 'register');
    Route::post('login', 'login');
    Route::post('verify-otp','otpVerify');
});
Route::middleware(['auth:sanctum', 'type.customer'])->group(function () {
    Route::get('load-date-slots/{id}',[ BookingController::class,'loadDateAndSlots']);
    Route::get('load-dates',[ BookingController::class,'LoadDates']); 
    Route::get('couch-load-dates/{id}',[CouchingController::class,'LoadDates']); 
    Route::get('load-category',[CouchingController::class,'loadCouch']); 
    #couching
    Route::get('load-couch/{id}',[CouchingController::class,'loadCouch']); 
    Route::get('couching/{sid}',[CouchingController::class,'index']); 
    Route::get('load-couching-court/{sid}/{cat}/{level}',[CouchingController::class,'loadCouchingCourt']); 
    Route::get('couching-court-session/{sid}/{cat}/{level}/{cid}',[CouchingController::class,'loadCouchingCourtSession']); 
    Route::get('couching-select-date/{sid}/{cat}/{level}/{cid}/{session_id}',[CouchingController::class,'loadCouchingSlotDate']); 
    Route::get('couching-get-timeings/{sid}/{cat}/{level}/{cid}/{session_id}/{date}',[CouchingController::class,'loadCouchingSlotTimings']); 
    Route::get('couching-pick-time/{sid}/{cat}/{level}/{cid}/{session_id}/{date}/{time}',[CouchingController::class,'loadCouchingSlotTimeSelect']); 
    Route::post('coaching-book',[CouchingController::class,'coachingBook']);
    Route::post('coaching-book-update',[CouchingController::class,'coachingBookUpdate']);
    Route::post('coaching-booking-history',[CouchingController::class,'coachingBookHistory']);
    Route::post('coaching-history',[CouchingController::class,'listCoachingBookHistory']);
    #slotBooking
    Route::get('load-booking/{id}',[BookingController::class,'loadBooking']); 
    Route::get('load-booking-courts/{id}/{did}',[BookingController::class,'loadBookingCourts']); 
    Route::get('load-booking-court-time/{id}/{did}/{cid}',[BookingController::class,'loadBookingCourtsTime']); 
    Route::post('slot-book',[BookingController::class,'slotBook']);
    Route::post('slot-book-update',[BookingController::class,'slotBookUpdate']);
    Route::post('update-slot-booking-history',[BookingController::class,'updateSlotBookingHistory']);
    Route::post('slot-booking-history',[BookingController::class,'slotBookingHistory']);
    Route::post('slot-cancel',[BookingController::class,'slotCancel']);
    #playCoin
    Route::post('play-coins',[UserProfileController::class,'getPlayCoinsDetails']);
    #BasicApi
    Route::get('load-sports',[SportsController::class,'getSports']); 
    #Membership
    Route::get('load-membership-packages',[MembershipPackageController::class,'getPackages']); 
    Route::post('purchase-membership',[MembershipPackageController::class,'purchaseMembership']); 
    Route::post('update-membership',[MembershipPackageController::class,'purchaseMembershipUpdate']); 
    #reviews
    Route::get('get-reviews/{court_id}',[ReviewController::class,'getReviews']); 
    #complaints
    Route::post('raise-complaints',[ComplaintController::class,'save']);
    Route::post('show-complaints',[ComplaintController::class,'get']);
    Route::get('complaints-lists',[ComplaintController::class,'list']);
    #Tournaments
    Route::get('upcoming-events',[TournamentContoller::class,'get']);
    #referal
    Route::get('referals',[SettingController::class,'referal']);
    #home
    Route::post('home',[HomeController::class,'index']);
    #home
    Route::get('profile',[ProfileController::class,'index']);
    Route::post('profile-update',[ProfileController::class,'update']);

    #Notification
    Route::get('notification',[NotificationController::class,'index']);
    Route::get('open-notification',[NotificationController::class,'openNotification']);

    Route::get('test-notifcation',[NotificationController::class,'sendPushNotification']);
    
});
