<?php
if (App::environment('production')) {
    URL::forceScheme('https');
}
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\SportsController;
use App\Http\Controllers\Admin\VenueController;
use App\Http\Controllers\Admin\CommonController;
use App\Http\Controllers\Admin\CourtController;
use App\Http\Controllers\Admin\MembershipController;
use App\Http\Controllers\Admin\PlayersController;
use App\Http\Controllers\Admin\BookingController;
use App\Http\Controllers\Admin\Setting\SettingController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Frontend\BookCourtController;
use App\Http\Controllers\Admin\CoachingController;
use App\Http\Controllers\Admin\TouranamentController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\BannerController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Auth::routes();
Route::group(['middleware' => ['auth']], function() {
    // Route::resource('roles', RoleController::class);
      Route::resource('users', UserController::class);
    // Route::resource('products', ProductController::class);
     Route::get('home', [DashboardController::class, 'index'])->name('home');
     Route::group(['prefix' => 'frontend', 'as' => 'frontend.'], function () {
        Route::get('load-court-slot/{court_id}', [BookCourtController::class,'loadDateAndSlots'])->name('load-court-slot');
    });
     Route::group(['prefix' => 'admin', 'as' => 'admin.'], function () {
        Route::resource('categories', CategoryController::class);
        Route::resource('dashboard', DashboardController::class);
        Route::resource('sports', SportsController::class);
        Route::resource('venues', VenueController::class);
        Route::resource('courts', CourtController::class);
        Route::get('load-timings/{id}', [CourtController::class, 'loadTimings'])->name('load-timings');
        Route::get('load-day-timings/{cid}/{did}', [CourtController::class, 'loadDayTimings'])->name('load-day-timings');
        Route::post('update-day-time', [CourtController::class,'updateTimings'])->name('update-day-time');
        Route::resource('membership', MembershipController::class);
        Route::resource('players', PlayersController::class);
        Route::get('players-export', [ PlayersController::class,'export'])->name('players-export');
        Route::resource('bookings', BookingController::class);
        Route::get('bookings-export', [ BookingController::class,'export'])->name('bookings-export');
        Route::post('booking-edit', [ BookingController::class,'bookingEdit'])->name('booking-edit');
        Route::resource('setting', SettingController::class);
        Route::resource('users', UserController::class);
        Route::resource('roles', RoleController::class);
        Route::get('play-coin-setting', [ SettingController::class,'playCoin'])->name('play-coin-setting');
        Route::get('referal-setting', [ SettingController::class,'referal'])->name('referal-setting');
        Route::get('players-type', [ PlayersController::class,'types'])->name('players-types');
        Route::get('court-time-schedule/{id}', [CourtController::class, 'timeSchedule'])->name('court-time-schedule');
        Route::post('save-court-time-schedule/{id}', [CourtController::class, 'saveTimeSchedule'])->name('save-court-time-schedule');
        Route::get('get-sports/{id}', [CommonController::class, 'getSports'])->name('get-sports');
        Route::get('get-courts/{id}', [CommonController::class, 'getCourts'])->name('get-courts');
        Route::get('get-slots/{id}', [CommonController::class, 'getSlots'])->name('get-slots');
        Route::get('players-type', [ PlayersController::class,'types'])->name('players-types');
        Route::get('court-custom-schedule/{id}', [CourtController::class, 'timeCustomSchedule'])->name('court-custom-schedule');
        Route::post('court-custom-schedule/{id}', [CourtController::class, 'timeSaveCustomSchedule'])->name('court-custom-schedule-save');
        Route::get('court-time-schedule-edit/{id}', [CourtController::class, 'timeCustomScheduleEdit'])->name('court-custom-schedule-edit');
        Route::put('court-time-schedule-update/{id}', [CourtController::class, 'timeCustomScheduleUpdate'])->name('court-custom-schedule-update');
        Route::delete('court-time-schedule-delete/{id}', [CourtController::class, 'timeCustomScheduleDelete'])->name('court-custom-schedule-delete');
        Route::get('court-timeing-slots-edit/{id}', [CourtController::class, 'timeCustomSlotTimingEdit'])->name('court-timeing-slots-edit');
        Route::post('court-timeing-slots-update/{id}', [CourtController::class, 'timeCustomSlotTimingUpdate'])->name('court-timeing-slots-update');
        Route::get('load-custom-slots-timing-tr', [ CourtController::class,'LoadCustomSlotsTimingTr'])->name('load-custom-slots-timing-tr');
        
        #Coaching SLot
        Route::get('get-couching-slots/{id}', [ CourtController::class,'getCouchingSlots'])->name('get-couching-slots');
        Route::post('save-couching-slots/{id}', [ CourtController::class,'saveCouchingSlots'])->name('save-couching-slots');
        Route::get('load-couching-slots-timing/{id}', [ CourtController::class,'LoadCouchingSlotsTiming'])->name('load-couching-slots-timing');
        Route::post('save-couching-slots-timing/{id}', [ CourtController::class,'LoadCouchingsaveSlotsTiming'])->name('save-couching-slots-timing');
        Route::get('load-couching-slots-timing-tr', [ CourtController::class,'LoadCouchingSlotsTimingTr'])->name('load-couching-slots-timing-tr');
        Route::post('quick-load-couching-slots-timing-tr', [ CourtController::class,'quickLoadCouchingSlotsTimingTr'])->name('quick-load-couching-slots-timing-tr');
        Route::get('edit-coaching-session/{id}', [ CourtController::class,'getCouchingSession'])->name('edit-coaching-session');
        Route::put('update-couching-slots/{cid}/{id}', [ CourtController::class,'updateCouchingSlots'])->name('update-couching-slots');
        
        #BookedCoaching
        Route::resource('coaching', CoachingController::class);

        #Tournaments
        Route::resource('touranament', TouranamentController::class);

        #Reports
        Route::get('booking-reports',[ReportController::class , 'booking'])->name('booking-reports');
        Route::post('booking-reports',[ReportController::class , 'bookingPost'])->name('post-booking-reports');
        
        Route::get('customer-reports',[ReportController::class , 'customer'])->name('customer-reports');
        Route::get('customer-reports-days-select',[ReportController::class , 'customer'])->name('customer-reports');
       // Route::post('customer-reports-date-select', ReportController::class,'customer');
       
        #Banner
        Route::resource('banner', BannerController::class);


    });
   
   
    
});
Route::get('about-us/', function () {
    return view('pages.about-us');
});
Route::get('terms-and-conditions/', function () {
    return view('pages.terms');
});
Route::get('privacy_policy/', function () {
    return view('pages.privacy_policy');
});
