<?php $__env->startPush('styles'); ?>
    <!--begin::Vendor Stylesheets(used by this page)-->
    <link href="<?php echo e(asset('admin/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link href="<?php echo e(asset('admin/assets/plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet"
        type="text/css" />
    <!--end::Vendor Stylesheets-->
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title'); ?>
    <title>Membership Plans</title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">

        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">

            <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">

                <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                    Membership</h1>

                <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">

                    <li class="breadcrumb-item text-muted">
                        <a href="#" class="text-muted text-hover-primary">Home</a>
                    </li>


                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-400 w-5px h-2px"></span>
                    </li>


                    <li class="breadcrumb-item text-muted">Plans</li>

                </ul>

            </div>
            <div class="d-flex align-items-center gap-2 gap-lg-3">

                <a href="#" class="btn btn-sm fw-bold btn-primary" id="add_sports">Add Plans</a>

            </div>

        </div>

    </div>


    <div id="" class="app-content flex-column-fluid">

        <div id="" class="app-container container-fluid">

            <div class="row g-5 g-xl-10 mb-5 mb-xl-10">



                <div class="col-xxl-12">
                    <div class="card card-flush mt-2">

                        <div class="card-header mt-5">

                            <div class="card-title flex-column">
                                <h3 class="fw-bold mb-1"> List</h3>
                            </div>
                        </div>

                        <div class="card-body pt-0">
                            <div class="table-responsive">

                                <table id="membership_table"
                                    class="table table-row-bordered table-row-dashed gs-3 align-middle fw-bold">

                                    <thead class="fs-7 text-gray-400 text-uppercase">
                                        <tr>
                                            <th class="min-w-90px">Id</th>
                                            <th class="min-w-90px">Duration Name</th>
                                            <th class="min-w-90px">Plan Name</th>
                                            <th class="min-w-90px">Discount</th>
                                            <th class="min-w-150px">Price</th>
                                            <th class="min-w-50px">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="fs-6">

                                    </tbody>

                                </table>

                            </div>

                        </div>

                    </div>

                </div>

            </div>


        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal fade" id="kt_modal_new_target" tabindex="-1" role="dialog">
        <!--begin::Modal dialog-->
        <div class="modal-dialog modal-dialog-centered mw-650px">
            <!--begin::Modal content-->
            <div class="modal-content rounded">
                <!--begin::Modal header-->
                <div class="modal-header pb-0 border-0 justify-content-end">
                    <!--begin::Close-->
                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                        <span class="svg-icon svg-icon-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2"
                                    rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1"
                                    transform="rotate(45 7.41422 6)" fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                    </div>
                    <!--end::Close-->
                </div>
                <!--begin::Modal header-->
                <!--begin::Modal body-->
                <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                    <!--begin:Form-->
                    <form id="membership_form" class="form" enctype="multipart/form-data"
                        action="<?php echo e(route('admin.sports.store')); ?>" method="POST">
                        <div class="mb-13 text-center">
                            <h1 class="mb-3 add-label">Add Plans</h1>
                        </div>
                        <div class="row">
                            <div class="col">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Duration</span>
                                        <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                            title="Please select duration"></i>
                                    </label>
                                    <select class="form-select form-select-solid" data-control="select2"
                                        data-hide-search="true" data-placeholder="Select Duration" name="mem_duration">
                                        <option value="">Select</option>
                                        <?php $__currentLoopData = $duration; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($_data['id']); ?>"><?php echo e($_data['dur_name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>

                                </div>
                            </div>
                            <div class="col">
                                <div class="d-flex flex-column mb-8 fv-row">
                                    <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                        <span class="required">Package</span>
                                        <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                            title="Please select duration"></i>
                                    </label>
                                    <select class="form-select form-select-solid" data-control="select2"
                                        data-hide-search="true" data-placeholder="Select Duration" name="mem_package">
                                        <option value="">Select</option>
                                        <?php $__currentLoopData = $package; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($_data['id']); ?>"><?php echo e($_data['plan_name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>

                                    <div id="append_div"></div>

                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <div class="d-flex flex-column mb-8 fv-row">
                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                            <span class="required">Discount</span>
                                            <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                                title="Please enter sports"></i>
                                        </label>
                                        <input type="text" class="form-control form-control-solid"
                                            placeholder="Please enter amount" name="mem_discount" id="mem_discount" />

                                    </div>
                                </div>
                                <div class="col">

                                    <div class="d-flex flex-column mb-8 fv-row">
                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                            <span class="required">Image Json</span>
                                            <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                                title="Please Package Price"></i>
                                        </label>
                                        <div>
                                            <input type="file" class="form-control form-control-solid"
                                                name="image_json" id="image_json">

                                        </div>

                                    </div>


                                </div>

                                <div class="row">
                                    <div class="col">
                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                            <span class="required">Enter Price</span>
                                            <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                                title="Please Package Price"></i>
                                        </label>
                                        <input type="text" class="form-control form-control-solid"
                                            placeholder="Please enter Price" name="mem_price" id="mem_price" />
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col">
                                        <label class="d-flex align-items-center fs-6 fw-semibold mb-2">
                                            <span class="required">Membership Description</span>
                                            <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip"
                                                title="Please Package Price"></i>
                                        </label>
                                        <div class="row">
                                            <div class="col">
                                                <table id="membership_desc_table"
                                                    class="table table-row-bordered table-row-dashed gy-4 align-middle fw-bold table table-row-bordered align-middle gy-4 gs-9">
                                                    <thead
                                                        class="border-bottom border-gray-200 fs-6 text-gray-600 fw-bold bg-light bg-opacity-75">
                                                        <tr>
                                                            <th class="min-w-150px">Title</th>
                                                            <th class="min-w-150px">Mid Title</th>
                                                            <th class="min-w-150px">Description</th>
                                                            <th class="min-w-100px">Action</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody class="fs-6">
                                                        <tr>
                                                            <td>
                                                                <div class="input-group flex-nowrap">
                                                                    <input type="text" class="form-control"
                                                                        placeholder="Enter Dec Title"
                                                                        name="mem_dec_title[]">
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="input-group flex-nowrap">
                                                                    <input type="text" class="form-control"
                                                                        placeholder="Enter Second Title"
                                                                        name="mem_dec_title1[]">
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="input-group flex-nowrap">
                                                                    <textarea class="form-control" name="mem_dec_desc[]"></textarea>
                                                                </div>
                                                            </td>

                                                            <td>
                                                                <button type="button"
                                                                    class="btn btn-icon btn-active-light-primary w-30px h-30px ms-auto add_membership_desc"
                                                                    data-id="" id="">
                                                                    <span class="svg-icon svg-icon-muted svg-icon-2hx">
                                                                        <svg width="24" height="24"
                                                                            viewBox="0 0 24 24" fill="none"
                                                                            xmlns="http://www.w3.org/2000/svg">
                                                                            <rect opacity="0.3" x="2"
                                                                                y="2" width="20"
                                                                                height="20" rx="10"
                                                                                fill="currentColor"></rect>
                                                                            <rect x="10.8891" y="17.8033"
                                                                                width="12" height="2"
                                                                                rx="1"
                                                                                transform="rotate(-90 10.8891 17.8033)"
                                                                                fill="currentColor"></rect>
                                                                            <rect x="6.01041" y="10.9247"
                                                                                width="12" height="2"
                                                                                rx="1" fill="currentColor"></rect>
                                                                        </svg>
                                                                    </span>
                                                                </button>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>

                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col"> <?php echo csrf_field(); ?></div>
                                </div>
                                <div class="row">

                                        <div class="col">
                                            <div class="text-center">
                                                <button type="reset" id="kt_modal_new_target_cancel" class="btn btn-light me-3">Cancel</button>
                                                <button type="submit" id="kt_modal_new_target_submit" class="btn btn-primary">
                                                    <span class="indicator-label">Submit</span>
                                                    <span class="indicator-progress">Please wait... <span
                                                            class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                                    </span>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                    </form>


                    <!--end:Form-->
                </div>
                <!--end::Modal body-->

            </div>
            <!--end::Modal content-->
        </div>
        <!--end::Modal dialog-->
        
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        var membership_index = '<?php echo e(route('admin.membership.index')); ?>';
        var membership_edit = '<?php echo e(route('admin.membership.edit', ':id')); ?>';
        var membership_delete = '<?php echo e(route('admin.membership.destroy', ':id')); ?>';
        var membership_store = '<?php echo e(route('admin.membership.store')); ?>';
        var membership_update = '<?php echo e(route('admin.membership.update', ':id')); ?>';
    </script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script src="<?php echo e(asset('admin/assets/js/custom/apps/membership/membership.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demo2innoblitz/public_html/qclub/resources/views/admin/membershipplans.blade.php ENDPATH**/ ?>